/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.processor;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.macros.core.model.Macros;
import org.qubership.atp.macros.core.parser.antlr4.MacrosParser;
import org.qubership.atp.macros.core.processor.DataKey;
import org.qubership.atp.macros.core.processor.Evaluator;
import org.qubership.atp.macros.core.processor.MacrosVisitorState;

public abstract class AbstractContext<T extends AbstractContext> {
    protected final T parent;
    protected Map<DataKey, Object> contextMap = null;
    protected Map<String, Object> contextParameters;
    protected MacrosVisitorState strategy;

    public AbstractContext() {
        this.parent = null;
        this.strategy = MacrosVisitorState.OUTSIDE_MACRO;
    }

    public AbstractContext(@Nonnull T parent, @Nonnull MacrosParser.MacrosStartContext macro, @Nonnull Macros macros, @Nonnull Evaluator evaluator) {
        this.parent = parent;
        this.strategy = MacrosVisitorState.IN_MACRO;
        this.notifyMacroStarts(macro, macros, evaluator);
    }

    protected abstract void notifyMacroStarts(@Nonnull MacrosParser.MacrosStartContext var1, @Nonnull Macros var2, @Nonnull Evaluator var3);

    protected abstract void pushArguments(@Nonnull MacrosParser.MacrosStartContext var1);

    protected abstract void pushArguments(@Nonnull MacrosParser.TextContext var1);

    protected abstract void pushArguments(@Nonnull MacrosParser.QuoteContext var1);

    protected abstract void pushArguments(@Nonnull MacrosParser.SlashContext var1);

    protected abstract void pushArguments(@Nonnull MacrosParser.MacroParamsContext var1);

    protected abstract void pushArguments(@Nonnull MacrosParser.MacrosEndContext var1);

    protected abstract void notifyMacroEnds(MacrosParser.MacrosEndContext var1);

    protected abstract void pushText(@Nonnull MacrosParser.MacrosStartContext var1);

    protected abstract void pushText(@Nonnull MacrosParser.TextContext var1);

    protected abstract void pushText(@Nonnull MacrosParser.QuoteContext var1);

    protected abstract void pushText(@Nonnull MacrosParser.SlashContext var1);

    protected abstract void pushText(@Nonnull MacrosParser.MacroParamsContext var1);

    protected abstract void pushText(@Nonnull MacrosParser.MacrosEndContext var1);

    @Nonnull
    protected abstract T createChildContext(@Nonnull MacrosParser.MacrosStartContext var1, @Nonnull Macros var2, Evaluator var3);

    protected abstract void reduce(@Nonnull MacrosParser.MacrosEndContext var1, @Nonnull T var2);

    public abstract T reset();

    @Nullable
    public abstract String getResultOnEvaluationEnd();

    @Nullable
    <K> K getData(@Nonnull DataKey<K> key) {
        if (this.contextMap == null) {
            return null;
        }
        return (K)this.contextMap.get(key);
    }

    <K> K setData(@Nonnull DataKey<K> key, @Nonnull K data) {
        if (this.contextMap == null) {
            this.contextMap = new IdentityHashMap<DataKey, Object>();
        }
        return (K)this.contextMap.put(key, data);
    }

    <K> K removeData(@Nonnull DataKey<K> key) {
        if (this.contextMap == null) {
            return null;
        }
        return (K)this.contextMap.remove(key);
    }

    public T getParent() {
        return this.parent;
    }

    public Map<DataKey, Object> getContextMap() {
        return this.contextMap;
    }

    public Map<String, Object> getContextParameters() {
        return this.contextParameters;
    }

    public MacrosVisitorState getStrategy() {
        return this.strategy;
    }

    public void setContextMap(Map<DataKey, Object> contextMap) {
        this.contextMap = contextMap;
    }

    public void setContextParameters(Map<String, Object> contextParameters) {
        this.contextParameters = contextParameters;
    }

    public void setStrategy(MacrosVisitorState strategy) {
        this.strategy = strategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractContext)) {
            return false;
        }
        AbstractContext other = (AbstractContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$parent = this.getParent();
        T other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        Map<DataKey, Object> this$contextMap = this.getContextMap();
        Map<DataKey, Object> other$contextMap = other.getContextMap();
        if (this$contextMap == null ? other$contextMap != null : !((Object)this$contextMap).equals(other$contextMap)) {
            return false;
        }
        Map<String, Object> this$contextParameters = this.getContextParameters();
        Map<String, Object> other$contextParameters = other.getContextParameters();
        if (this$contextParameters == null ? other$contextParameters != null : !((Object)this$contextParameters).equals(other$contextParameters)) {
            return false;
        }
        MacrosVisitorState this$strategy = this.getStrategy();
        MacrosVisitorState other$strategy = other.getStrategy();
        return !(this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        Map<DataKey, Object> $contextMap = this.getContextMap();
        result = result * 59 + ($contextMap == null ? 43 : ((Object)$contextMap).hashCode());
        Map<String, Object> $contextParameters = this.getContextParameters();
        result = result * 59 + ($contextParameters == null ? 43 : ((Object)$contextParameters).hashCode());
        MacrosVisitorState $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractContext(parent=" + this.getParent() + ", contextMap=" + this.getContextMap() + ", contextParameters=" + this.getContextParameters() + ", strategy=" + this.getStrategy() + ")";
    }
}

