/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.annotation.NewSpanParser;
import org.springframework.cloud.sleuth.annotation.NoOpTagValueResolver;
import org.springframework.cloud.sleuth.annotation.SleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.annotation.TagValueExpressionResolver;
import org.springframework.cloud.sleuth.annotation.TagValueResolver;
import org.springframework.cloud.sleuth.instrument.annotation.DefaultSpanCreator;
import org.springframework.cloud.sleuth.instrument.annotation.NonReactorSleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.instrument.annotation.ReactorSleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.instrument.annotation.SleuthAdvisorConfig;
import org.springframework.cloud.sleuth.instrument.annotation.SpelTagValueExpressionResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
@ConditionalOnProperty(name={"spring.sleuth.enabled", "spring.sleuth.annotation.enabled"}, matchIfMissing=true)
public class SleuthAnnotationConfiguration {
    @Bean
    @ConditionalOnMissingBean
    NewSpanParser newSpanParser() {
        return new DefaultSpanCreator();
    }

    @Bean
    @ConditionalOnMissingBean
    TagValueExpressionResolver spelTagValueExpressionResolver() {
        return new SpelTagValueExpressionResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    TagValueResolver noOpTagValueResolver() {
        return new NoOpTagValueResolver();
    }

    @Bean
    @Role(value=2)
    SleuthAdvisorConfig sleuthAdvisorConfig() {
        return new SleuthAdvisorConfig();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnClass(name={"reactor.core.publisher.Flux"})
    SleuthMethodInvocationProcessor reactorSleuthMethodInvocationProcessor() {
        return new ReactorSleuthMethodInvocationProcessor();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingClass(value={"reactor.core.publisher.Flux"})
    SleuthMethodInvocationProcessor nonReactorSleuthMethodInvocationProcessor() {
        return new NonReactorSleuthMethodInvocationProcessor();
    }
}

