/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper;

import java.io.Serializable;
import org.modelmapper.AbstractCondition;
import org.modelmapper.Condition;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.spi.MappingContext;

public class Conditions {
    private static final Condition<?, ?> IS_NULL = new AbstractCondition<Object, Object>(){
        private static final long serialVersionUID = 0L;

        @Override
        public boolean applies(MappingContext<Object, Object> context) {
            return context.getSource() == null;
        }

        public String toString() {
            return "isNull()";
        }
    };
    private static final Condition<?, ?> IS_NOT_NULL = new AbstractCondition<Object, Object>(){
        private static final long serialVersionUID = 0L;

        @Override
        public boolean applies(MappingContext<Object, Object> context) {
            return context.getSource() != null;
        }

        public String toString() {
            return "isNotNull()";
        }
    };

    public static <S, D> Condition<S, D> and(Condition<S, D> condition1, Condition<S, D> condition2) {
        Assert.notNull(condition1, "condition1");
        Assert.notNull(condition2, "condition2");
        return new AndCondition<S, D>(condition1, condition2);
    }

    public static Condition<?, ?> isNotNull() {
        return IS_NOT_NULL;
    }

    public static Condition<?, ?> isNull() {
        return IS_NULL;
    }

    public static Condition<?, ?> isType(final Class<?> type) {
        return new Condition<Object, Object>(){

            @Override
            public boolean applies(MappingContext<Object, Object> context) {
                return type.isAssignableFrom(context.getSourceType());
            }
        };
    }

    public static <S, D> Condition<S, D> not(Condition<S, D> condition) {
        Assert.notNull(condition, "condition");
        return new Not(condition);
    }

    public static <S, D> Condition<S, D> or(Condition<S, D> condition1, Condition<S, D> condition2) {
        Assert.notNull(condition1, "condition1");
        Assert.notNull(condition2, "condition2");
        return new OrCondition<S, D>(condition1, condition2);
    }

    private static class OrCondition<S, D>
    extends AbstractCondition<S, D>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Condition<S, D> a;
        private final Condition<S, D> b;

        OrCondition(Condition<S, D> a, Condition<S, D> b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean applies(MappingContext<S, D> context) {
            return this.a.applies(context) || this.b.applies(context);
        }

        public boolean equals(Object other) {
            return other instanceof OrCondition && ((OrCondition)other).a.equals(this.a) && ((OrCondition)other).b.equals(this.b);
        }

        public int hashCode() {
            return 37 * (this.a.hashCode() ^ this.b.hashCode());
        }

        public String toString() {
            return String.format("or(%s, %s)", this.a, this.b);
        }
    }

    private static class Not<S, D>
    extends AbstractCondition<S, D>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Condition<S, D> delegate;

        private Not(Condition<S, D> delegate) {
            this.delegate = Assert.notNull(delegate, "delegate");
        }

        @Override
        public boolean applies(MappingContext<S, D> context) {
            return !this.delegate.applies(context);
        }

        public boolean equals(Object other) {
            return other instanceof Not && ((Not)other).delegate.equals(this.delegate);
        }

        public int hashCode() {
            return -this.delegate.hashCode();
        }

        public String toString() {
            return "not(" + this.delegate + ")";
        }
    }

    private static class AndCondition<S, D>
    extends AbstractCondition<S, D>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Condition<S, D> a;
        private final Condition<S, D> b;

        AndCondition(Condition<S, D> a, Condition<S, D> b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean applies(MappingContext<S, D> context) {
            return this.a.applies(context) && this.b.applies(context);
        }

        public boolean equals(Object other) {
            return other instanceof AndCondition && ((AndCondition)other).a.equals(this.a) && ((AndCondition)other).b.equals(this.b);
        }

        public int hashCode() {
            return 41 * (this.a.hashCode() ^ this.b.hashCode());
        }

        public String toString() {
            return String.format("and(%s, %s)", this.a, this.b);
        }
    }
}

