/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.key;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.key.KeyGenerator;
import org.polyjdbc.core.key.Sequence;
import org.polyjdbc.core.key.SequenceNextValQuery;
import org.polyjdbc.core.transaction.Transaction;

public class SequenceAllocation
implements KeyGenerator {
    private static final long SEQUENCE_ALLOCATION_SIZE = 100L;
    private final Object lock = new Object();
    private final SequenceNextValQuery sequenceNextValQuery;
    private Map<String, Sequence> sequences = new ConcurrentHashMap<String, Sequence>();
    private ThreadLocal<Long> lastKey = new ThreadLocal();

    public SequenceAllocation(Dialect dialect) {
        this.sequenceNextValQuery = new SequenceNextValQuery(dialect);
    }

    SequenceAllocation(SequenceNextValQuery sequenceNextValQuery) {
        this.sequenceNextValQuery = sequenceNextValQuery;
    }

    @Override
    public long generateKey(String sequenceName, Transaction transaction) throws SQLException {
        long nextVal = this.findSequence(sequenceName).nextValue(this.sequenceNextValQuery, transaction);
        this.lastKey.set(nextVal);
        return nextVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence findSequence(String sequenceName) {
        if (!this.sequences.containsKey(sequenceName)) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.sequences.containsKey(sequenceName)) {
                    Sequence sequence = new Sequence(sequenceName, 100L);
                    this.sequences.put(sequenceName, sequence);
                }
            }
        }
        return this.sequences.get(sequenceName);
    }

    @Override
    public long getKeyFromLastInsert(Transaction transaction) {
        return this.lastKey.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.sequences.clear();
        }
    }
}

