/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.polyjdbc.core.transaction.Transaction;
import org.polyjdbc.core.type.ColumnTypeMapper;
import org.polyjdbc.core.type.SqlType;
import org.polyjdbc.core.type.TypeWrapper;
import org.polyjdbc.core.util.StringBuilderUtil;

public class Query {
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile("\\:[A-Za-z0-9_-]*");
    private static final String QUERY_PLACEHOLDER = "?";
    private static final int AVERAGE_QUERY_LENGTH = 100;
    private static final int ARGUMENT_REPLACEMENT_SIZE = 10;
    private final ColumnTypeMapper typeMapper;
    private String originalQuery;
    private String query;
    private StringBuilder builder = new StringBuilder(100);
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private final List<Object> orderedArguments = new ArrayList<Object>();
    private boolean compiled = false;

    Query(ColumnTypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public Query append(String string) {
        this.builder.append(string);
        return this;
    }

    Query overwrite(String string) {
        this.builder = new StringBuilder(100);
        this.builder.append(string);
        return this;
    }

    public Query wrap(String prefix, String sufix) {
        this.builder.insert(0, prefix).append(sufix);
        return this;
    }

    public Query setArgument(String name, Object value) {
        this.arguments.put(name, value);
        return this;
    }

    public void clearArguments() {
        this.query = this.originalQuery;
        this.arguments.clear();
        this.orderedArguments.clear();
        this.compiled = false;
    }

    void compile() {
        this.query = this.originalQuery = this.builder.toString();
        Matcher matcher = ARGUMENT_PATTERN.matcher(this.query);
        while (matcher.find()) {
            String foundPattern = matcher.group();
            String argumentName = foundPattern.substring(1);
            this.orderedArguments.add(this.arguments.get(argumentName));
            String replacement = this.createReplacement(this.arguments.get(argumentName));
            this.query = this.query.replaceFirst(foundPattern, replacement);
        }
        this.compiled = true;
    }

    private String createReplacement(Object argument) {
        if (this.isCollection(argument)) {
            Iterator<?> iterator = this.createCollectionIterator(argument);
            StringBuilder replacementBuilder = new StringBuilder(10);
            if (!iterator.hasNext()) {
                return "";
            }
            while (iterator.hasNext()) {
                replacementBuilder.append(QUERY_PLACEHOLDER).append(", ");
                iterator.next();
            }
            StringBuilderUtil.deleteLastCharacters(replacementBuilder, 2);
            return replacementBuilder.toString();
        }
        return QUERY_PLACEHOLDER;
    }

    public void injectValues(PreparedStatement preparedStatement) throws SQLException {
        int argumentNumber = 1;
        for (Object argument : this.orderedArguments) {
            if (this.isCollection(argument)) {
                Iterator<?> iterator = this.createCollectionIterator(argument);
                while (iterator.hasNext()) {
                    this.injectValue(preparedStatement, argumentNumber, iterator.next());
                    ++argumentNumber;
                }
                continue;
            }
            this.injectValue(preparedStatement, argumentNumber, argument);
            ++argumentNumber;
        }
    }

    private void injectValue(PreparedStatement preparedStatement, int argumentNumber, Object value) throws SQLException {
        if (value != null) {
            SqlType type = this.typeMapper.forClass(value.getClass());
            Object injectedValue = value;
            if (value instanceof TypeWrapper) {
                injectedValue = ((TypeWrapper)value).value();
            } else if (value instanceof Date) {
                injectedValue = new java.sql.Date(((Date)value).getTime());
            } else if (value instanceof Character) {
                injectedValue = String.valueOf(value);
            } else if (value instanceof Boolean) {
                preparedStatement.setBoolean(argumentNumber, (Boolean)value);
                return;
            }
            preparedStatement.setObject(argumentNumber, injectedValue, type.code());
        } else {
            preparedStatement.setObject(argumentNumber, null);
        }
    }

    private boolean isCollection(Object object) {
        return object != null && (Iterable.class.isAssignableFrom(object.getClass()) || object.getClass().isArray());
    }

    private Iterator<?> createCollectionIterator(Object argument) {
        Iterator<Object> iterator = argument.getClass().isArray() ? Arrays.asList((Object[])argument).iterator() : ((Iterable)argument).iterator();
        return iterator;
    }

    public PreparedStatement createStatement(Transaction transaction) throws SQLException {
        if (!this.compiled) {
            this.compile();
        }
        return transaction.prepareStatement(this.query);
    }

    public PreparedStatement createStatementWithValues(Transaction transaction) throws SQLException {
        PreparedStatement preparedStatement = this.createStatement(transaction);
        this.injectValues(preparedStatement);
        return preparedStatement;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        return this.originalQuery;
    }
}

