/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.data.Index;
import org.assertj.core.error.ConditionAndGroupGenericParameterTypeShouldBeTheSame;
import org.assertj.core.error.ElementsShouldBe;
import org.assertj.core.error.ElementsShouldBeAtLeast;
import org.assertj.core.error.ElementsShouldBeAtMost;
import org.assertj.core.error.ElementsShouldBeExactly;
import org.assertj.core.error.ElementsShouldHave;
import org.assertj.core.error.ElementsShouldHaveAtLeast;
import org.assertj.core.error.ElementsShouldHaveAtMost;
import org.assertj.core.error.ElementsShouldHaveExactly;
import org.assertj.core.error.ElementsShouldNotBe;
import org.assertj.core.error.ElementsShouldNotHave;
import org.assertj.core.error.ShouldBeAnArray;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldBeSorted;
import org.assertj.core.error.ShouldBeSubsetOf;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldContainAtIndex;
import org.assertj.core.error.ShouldContainExactly;
import org.assertj.core.error.ShouldContainExactlyInAnyOrder;
import org.assertj.core.error.ShouldContainNull;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainOnlyNulls;
import org.assertj.core.error.ShouldContainSequence;
import org.assertj.core.error.ShouldContainSubsequence;
import org.assertj.core.error.ShouldContainsOnlyOnce;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainAtIndex;
import org.assertj.core.error.ShouldNotContainNull;
import org.assertj.core.error.ShouldNotContainSequence;
import org.assertj.core.error.ShouldNotContainSubsequence;
import org.assertj.core.error.ShouldNotHaveDuplicates;
import org.assertj.core.error.ShouldOnlyHaveElementsOfTypes;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.IterableDiff;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.ArrayWrapperList;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Arrays {
    private static final Arrays INSTANCE = new Arrays();
    private final ComparisonStrategy comparisonStrategy;

    public static Arrays instance() {
        return INSTANCE;
    }

    public Arrays() {
        this(StandardComparisonStrategy.instance());
    }

    public Arrays(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (!(this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy)) {
            return null;
        }
        return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
    }

    @VisibleForTesting
    public ComparisonStrategy getComparisonStrategy() {
        return this.comparisonStrategy;
    }

    public static void assertIsArray(AssertionInfo info, Object array) {
        if (!org.assertj.core.util.Arrays.isArray(array)) {
            throw Failures.instance().failure(info, ShouldBeAnArray.shouldBeAnArray(array));
        }
    }

    void assertNullOrEmpty(AssertionInfo info, Failures failures, Object array) {
        if (array != null && !Arrays.isArrayEmpty(array)) {
            throw failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(array));
        }
    }

    void assertEmpty(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (!Arrays.isArrayEmpty(array)) {
            throw failures.failure(info, ShouldBeEmpty.shouldBeEmpty(array));
        }
    }

    void assertHasSize(AssertionInfo info, Object array, int expectedSize) {
        Arrays.assertNotNull(info, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizes(array, sizeOfActual, expectedSize, info);
    }

    void assertHasSizeGreaterThan(AssertionInfo info, Object array, int boundary) {
        Arrays.assertNotNull(info, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeGreaterThan(array, boundary, sizeOfActual, info);
    }

    void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info, Object array, int boundary) {
        Arrays.assertNotNull(info, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeGreaterThanOrEqualTo(array, boundary, sizeOfActual, info);
    }

    void assertHasSizeLessThan(AssertionInfo info, Object array, int boundary) {
        Arrays.assertNotNull(info, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeLessThan(array, boundary, sizeOfActual, info);
    }

    void assertHasSizeLessThanOrEqualTo(AssertionInfo info, Object array, int expectedSize) {
        Arrays.assertNotNull(info, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeLessThanOrEqualTo(array, expectedSize, sizeOfActual, info);
    }

    void assertHasSizeBetween(AssertionInfo info, Object array, int lowerBoundary, int higherBoundary) {
        Arrays.assertNotNull(info, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeBetween(array, lowerBoundary, higherBoundary, sizeOfActual, info);
    }

    void assertHasSameSizeAs(AssertionInfo info, Object array, Iterable<?> other) {
        Arrays.assertNotNull(info, array);
        CommonValidations.hasSameSizeAsCheck(info, array, other, org.assertj.core.util.Arrays.sizeOf(array));
    }

    public void assertHasSameSizeAs(AssertionInfo info, Object array, Object other) {
        Arrays.assertNotNull(info, array);
        Arrays.assertIsArray(info, array);
        Arrays.assertIsArray(info, other);
        CommonValidations.hasSameSizeAsCheck(info, array, other, org.assertj.core.util.Arrays.sizeOf(array));
    }

    @VisibleForTesting
    public void assertContains(AssertionInfo info, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info, actual, values)) {
            return;
        }
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        int valueCount = org.assertj.core.util.Arrays.sizeOf(values);
        for (int i = 0; i < valueCount; ++i) {
            Object value = Array.get(values, i);
            if (this.arrayContains(actual, value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            throw failures.failure(info, ShouldContain.shouldContain(actual, values, notFound, this.comparisonStrategy));
        }
    }

    void assertcontainsAll(AssertionInfo info, Failures failures, Object array, Iterable<?> iterable) {
        if (iterable == null) {
            throw CommonErrors.iterableToLookForIsNull();
        }
        Arrays.assertNotNull(info, array);
        Object[] values = Lists.newArrayList(iterable).toArray();
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        for (Object value : values) {
            if (this.arrayContains(array, value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            throw failures.failure(info, ShouldContain.shouldContain(array, values, notFound, this.comparisonStrategy));
        }
    }

    void assertContains(AssertionInfo info, Failures failures, Object array, Object value, Index index) {
        Arrays.assertNotNull(info, array);
        this.assertNotEmpty(info, failures, array);
        CommonValidations.checkIndexValueIsValid(index, org.assertj.core.util.Arrays.sizeOf(array) - 1);
        Object actualElement = Array.get(array, index.value);
        if (!this.areEqual(actualElement, value)) {
            throw failures.failure(info, ShouldContainAtIndex.shouldContainAtIndex(array, value, index, Array.get(array, index.value), this.comparisonStrategy));
        }
    }

    void assertNotEmpty(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (Arrays.isArrayEmpty(array)) {
            throw failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    void assertDoesNotContain(AssertionInfo info, Failures failures, Object array, Object value, Index index) {
        Arrays.assertNotNull(info, array);
        CommonValidations.checkIndexValueIsValid(index, Integer.MAX_VALUE);
        if (index.value >= org.assertj.core.util.Arrays.sizeOf(array)) {
            return;
        }
        if (this.areEqual(Array.get(array, index.value), value)) {
            throw failures.failure(info, ShouldNotContainAtIndex.shouldNotContainAtIndex(array, value, index, this.comparisonStrategy));
        }
    }

    void assertContainsOnly(AssertionInfo info, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info, actual, values)) {
            return;
        }
        List notExpected = Arrays.asList(actual);
        List notFound = Arrays.asList(values);
        for (Object value : Arrays.asList(values)) {
            if (!this.iterableContains(notExpected, value)) continue;
            this.iterableRemoves(notExpected, value);
            this.iterableRemoves(notFound, value);
        }
        if (!notExpected.isEmpty() || !notFound.isEmpty()) {
            throw failures.failure(info, ShouldContainOnly.shouldContainOnly(actual, values, notFound, notExpected, this.comparisonStrategy));
        }
    }

    void assertContainsOnlyNulls(AssertionInfo info, Failures failures, Object[] actual) {
        Arrays.assertNotNull(info, actual);
        if (actual.length == 0) {
            throw failures.failure(info, ShouldContainOnlyNulls.shouldContainOnlyNulls(actual));
        }
        ArrayList<Object> nonNullElements = new ArrayList<Object>();
        for (Object element : actual) {
            if (element == null) continue;
            nonNullElements.add(element);
        }
        if (nonNullElements.size() > 0) {
            throw failures.failure(info, ShouldContainOnlyNulls.shouldContainOnlyNulls(actual, nonNullElements));
        }
    }

    void assertContainsExactly(AssertionInfo info, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info, actual, values)) {
            return;
        }
        Arrays.assertIsArray(info, actual);
        Arrays.assertIsArray(info, values);
        List actualAsList = Arrays.asList(actual);
        IterableDiff diff = IterableDiff.diff(actualAsList, Arrays.asList(values), this.comparisonStrategy);
        if (!diff.differencesFound()) {
            int arrayLength = org.assertj.core.util.Arrays.sizeOf(actual);
            for (int i = 0; i < arrayLength; ++i) {
                Object expectedElement;
                Object actualElement = Array.get(actual, i);
                if (this.areEqual(actualElement, expectedElement = Array.get(values, i))) continue;
                throw failures.failure(info, ShouldContainExactly.elementsDifferAtIndex(actualElement, expectedElement, i, this.comparisonStrategy));
            }
            return;
        }
        throw failures.failure(info, ShouldContainExactly.shouldContainExactly(actual, Arrays.asList(values), diff.missing, diff.unexpected, this.comparisonStrategy));
    }

    void assertContainsExactlyInAnyOrder(AssertionInfo info, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info, actual, values)) {
            return;
        }
        List notExpected = Arrays.asList(actual);
        List notFound = Arrays.asList(values);
        for (Object value : Arrays.asList(values)) {
            if (!this.iterableContains(notExpected, value)) continue;
            this.iterablesRemoveFirst(notExpected, value);
            this.iterablesRemoveFirst(notFound, value);
        }
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            return;
        }
        throw failures.failure(info, ShouldContainExactlyInAnyOrder.shouldContainExactlyInAnyOrder(actual, values, notFound, notExpected, this.comparisonStrategy));
    }

    void assertContainsOnlyOnce(AssertionInfo info, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info, actual, values)) {
            return;
        }
        Iterable<?> actualDuplicates = this.comparisonStrategy.duplicatesFrom(Arrays.asList(actual));
        LinkedHashSet notFound = new LinkedHashSet();
        LinkedHashSet notOnlyOnce = new LinkedHashSet();
        for (Object expectedElement : Arrays.asList(values)) {
            if (!this.arrayContains(actual, expectedElement)) {
                notFound.add(expectedElement);
                continue;
            }
            if (!this.iterableContains(actualDuplicates, expectedElement)) continue;
            notOnlyOnce.add(expectedElement);
        }
        if (!notFound.isEmpty() || !notOnlyOnce.isEmpty()) {
            throw failures.failure(info, ShouldContainsOnlyOnce.shouldContainsOnlyOnce(actual, values, notFound, notOnlyOnce, this.comparisonStrategy));
        }
    }

    private boolean iterableContains(Iterable<?> actual, Object value) {
        return this.comparisonStrategy.iterableContains(actual, value);
    }

    private void iterablesRemoveFirst(Collection<?> actual, Object value) {
        this.comparisonStrategy.iterablesRemoveFirst(actual, value);
    }

    private void iterableRemoves(Collection<?> actual, Object value) {
        this.comparisonStrategy.iterableRemoves(actual, value);
    }

    void assertContainsSequence(AssertionInfo info, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info, actual, sequence)) {
            return;
        }
        int lastIndexWhereSequenceCanBeFound = org.assertj.core.util.Arrays.sizeOf(actual) - org.assertj.core.util.Arrays.sizeOf(sequence);
        for (int actualIndex = 0; actualIndex <= lastIndexWhereSequenceCanBeFound; ++actualIndex) {
            if (!this.containsSequenceAtGivenIndex(actualIndex, actual, sequence)) continue;
            return;
        }
        throw failures.failure(info, ShouldContainSequence.shouldContainSequence(actual, sequence, this.comparisonStrategy));
    }

    void assertDoesNotContainSequence(AssertionInfo info, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info, actual, sequence)) {
            return;
        }
        int lastIndexWhereSequenceCanBeFound = org.assertj.core.util.Arrays.sizeOf(actual) - org.assertj.core.util.Arrays.sizeOf(sequence);
        for (int actualIndex = 0; actualIndex <= lastIndexWhereSequenceCanBeFound; ++actualIndex) {
            if (!this.containsSequenceAtGivenIndex(actualIndex, actual, sequence)) continue;
            throw failures.failure(info, ShouldNotContainSequence.shouldNotContainSequence(actual, sequence, actualIndex, this.comparisonStrategy));
        }
    }

    private boolean containsSequenceAtGivenIndex(int actualStartIndex, Object actualArray, Object sequence) {
        int sequenceSize = org.assertj.core.util.Arrays.sizeOf(sequence);
        for (int i = 0; i < sequenceSize; ++i) {
            if (this.areEqual(Array.get(sequence, i), Array.get(actualArray, i + actualStartIndex))) continue;
            return false;
        }
        return true;
    }

    void assertContainsSubsequence(AssertionInfo info, Failures failures, Object actual, Object subsequence) {
        int sizeOfSubsequence;
        if (Arrays.commonChecks(info, actual, subsequence)) {
            return;
        }
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(actual);
        if (sizeOfActual < (sizeOfSubsequence = org.assertj.core.util.Arrays.sizeOf(subsequence))) {
            throw failures.failure(info, ShouldContainSubsequence.actualDoesNotHaveEnoughElementsToContainSubsequence(actual, subsequence));
        }
        int subsequenceIndex = 0;
        for (int actualIndex = 0; actualIndex < sizeOfActual && subsequenceIndex < sizeOfSubsequence; ++actualIndex) {
            if (!this.areEqual(Array.get(actual, actualIndex), Array.get(subsequence, subsequenceIndex))) continue;
            ++subsequenceIndex;
        }
        if (subsequenceIndex < sizeOfSubsequence) {
            throw failures.failure(info, ShouldContainSubsequence.shouldContainSubsequence(actual, subsequence, subsequenceIndex, this.comparisonStrategy));
        }
    }

    void assertHasOnlyElementsOfTypes(AssertionInfo info, Failures failures, Object actual, Class<?>[] expectedTypes) {
        Arrays.checkIsNotNull(expectedTypes);
        Arrays.assertNotNull(info, actual);
        ArrayList nonMatchingElements = Lists.newArrayList();
        for (Object value : Arrays.asList(actual)) {
            boolean matching = false;
            for (Class<?> expectedType : expectedTypes) {
                if (!expectedType.isInstance(value)) continue;
                matching = true;
            }
            if (matching) continue;
            nonMatchingElements.add(value);
        }
        if (!nonMatchingElements.isEmpty()) {
            throw failures.failure(info, ShouldOnlyHaveElementsOfTypes.shouldOnlyHaveElementsOfTypes(actual, expectedTypes, nonMatchingElements));
        }
    }

    void assertDoesNotContainSubsequence(AssertionInfo info, Failures failures, Object actual, Object subsequence) {
        if (Arrays.commonChecks(info, actual, subsequence)) {
            return;
        }
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(actual);
        int sizeOfSubsequence = org.assertj.core.util.Arrays.sizeOf(subsequence);
        int lastIndexWhereEndOfSubsequenceCanBeFound = sizeOfActual - sizeOfSubsequence;
        int subsequenceIndex = 0;
        int subsequenceStartIndex = 0;
        for (int actualIndex = 0; actualIndex <= lastIndexWhereEndOfSubsequenceCanBeFound && subsequenceIndex < sizeOfSubsequence; ++actualIndex) {
            if (!this.areEqual(Array.get(actual, actualIndex), Array.get(subsequence, subsequenceIndex))) continue;
            if (subsequenceIndex == 0) {
                subsequenceStartIndex = actualIndex;
            }
            ++subsequenceIndex;
            ++lastIndexWhereEndOfSubsequenceCanBeFound;
            if (subsequenceIndex != sizeOfSubsequence) continue;
            throw failures.failure(info, ShouldNotContainSubsequence.shouldNotContainSubsequence(actual, subsequence, this.comparisonStrategy, subsequenceStartIndex));
        }
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    void assertDoesNotContain(AssertionInfo info, Failures failures, Object array, Object values) {
        Arrays.checkIsNotNullAndNotEmpty(values);
        Arrays.assertNotNull(info, array);
        LinkedHashSet<Object> found = new LinkedHashSet<Object>();
        int valuesSize = org.assertj.core.util.Arrays.sizeOf(values);
        for (int i = 0; i < valuesSize; ++i) {
            Object value = Array.get(values, i);
            if (!this.arrayContains(array, value)) continue;
            found.add(value);
        }
        if (!found.isEmpty()) {
            throw failures.failure(info, ShouldNotContain.shouldNotContain(array, values, found, this.comparisonStrategy));
        }
    }

    private boolean arrayContains(Object array, Object value) {
        return this.comparisonStrategy.arrayContains(array, value);
    }

    void assertDoesNotHaveDuplicates(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        ArrayWrapperList wrapped = ArrayWrapperList.wrap(array);
        Iterable<?> duplicates = this.comparisonStrategy.duplicatesFrom(wrapped);
        if (!IterableUtil.isNullOrEmpty(duplicates)) {
            throw failures.failure(info, ShouldNotHaveDuplicates.shouldNotHaveDuplicates(array, duplicates, this.comparisonStrategy));
        }
    }

    void assertStartsWith(AssertionInfo info, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info, actual, sequence)) {
            return;
        }
        int sequenceSize = org.assertj.core.util.Arrays.sizeOf(sequence);
        int arraySize = org.assertj.core.util.Arrays.sizeOf(actual);
        if (arraySize < sequenceSize) {
            throw this.arrayDoesNotStartWithSequence(info, failures, actual, sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            if (this.areEqual(Array.get(sequence, i), Array.get(actual, i))) continue;
            throw this.arrayDoesNotStartWithSequence(info, failures, actual, sequence);
        }
    }

    private static boolean commonChecks(AssertionInfo info, Object actual, Object sequence) {
        Arrays.checkNulls(info, actual, sequence);
        if (Arrays.isArrayEmpty(actual) && Arrays.isArrayEmpty(sequence)) {
            return true;
        }
        Arrays.failIfEmptySinceActualIsNotEmpty(sequence);
        return false;
    }

    private static void checkNulls(AssertionInfo info, Object actual, Object sequence) {
        Arrays.checkIsNotNull(sequence);
        Arrays.assertNotNull(info, actual);
    }

    private AssertionError arrayDoesNotStartWithSequence(AssertionInfo info, Failures failures, Object array, Object sequence) {
        return failures.failure(info, ShouldStartWith.shouldStartWith(array, sequence, this.comparisonStrategy));
    }

    void assertEndsWith(AssertionInfo info, Failures failures, Object actual, Object first, Object[] rest) {
        Object[] sequence = org.assertj.core.util.Arrays.prepend(first, rest);
        this.assertEndsWith(info, failures, actual, sequence);
    }

    void assertEndsWith(AssertionInfo info, Failures failures, Object actual, Object sequence) {
        Arrays.checkNulls(info, actual, sequence);
        int sequenceSize = org.assertj.core.util.Arrays.sizeOf(sequence);
        int arraySize = org.assertj.core.util.Arrays.sizeOf(actual);
        if (arraySize < sequenceSize) {
            throw this.arrayDoesNotEndWithSequence(info, failures, actual, sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            int sequenceIndex = sequenceSize - (i + 1);
            int arrayIndex = arraySize - (i + 1);
            if (this.areEqual(Array.get(sequence, sequenceIndex), Array.get(actual, arrayIndex))) continue;
            throw this.arrayDoesNotEndWithSequence(info, failures, actual, sequence);
        }
    }

    public void assertIsSubsetOf(AssertionInfo info, Failures failures, Object actual, Iterable<?> values) {
        Arrays.assertNotNull(info, actual);
        CommonValidations.checkIterableIsNotNull(values);
        ArrayList extra = Lists.newArrayList();
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(actual);
        for (int i = 0; i < sizeOfActual; ++i) {
            Object actualElement = Array.get(actual, i);
            if (this.iterableContains(values, actualElement)) continue;
            extra.add(actualElement);
        }
        if (extra.size() > 0) {
            throw failures.failure(info, ShouldBeSubsetOf.shouldBeSubsetOf(actual, values, extra, this.comparisonStrategy));
        }
    }

    void assertContainsNull(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (!this.arrayContains(array, null)) {
            throw failures.failure(info, ShouldContainNull.shouldContainNull(array));
        }
    }

    void assertDoesNotContainNull(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (this.arrayContains(array, null)) {
            throw failures.failure(info, ShouldNotContainNull.shouldNotContainNull(array));
        }
    }

    public <E> void assertAre(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> notMatchingCondition = this.getElementsNotMatchingCondition(info, failures, conditions, array, condition);
        if (!notMatchingCondition.isEmpty()) {
            throw failures.failure(info, ElementsShouldBe.elementsShouldBe(array, notMatchingCondition, condition));
        }
    }

    public <E> void assertAreNot(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info, failures, conditions, array, condition);
        if (!matchingElements.isEmpty()) {
            throw failures.failure(info, ElementsShouldNotBe.elementsShouldNotBe(array, matchingElements, condition));
        }
    }

    public <E> void assertHave(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> notMatchingCondition = this.getElementsNotMatchingCondition(info, failures, conditions, array, condition);
        if (!notMatchingCondition.isEmpty()) {
            throw failures.failure(info, ElementsShouldHave.elementsShouldHave(array, notMatchingCondition, condition));
        }
    }

    public <E> void assertHaveNot(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info, failures, conditions, array, condition);
        if (!matchingElements.isEmpty()) {
            throw failures.failure(info, ElementsShouldNotHave.elementsShouldNotHave(array, matchingElements, condition));
        }
    }

    public <E> void assertAreAtLeast(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info, failures, conditions, array, condition);
        if (matchingElements.size() < times) {
            throw failures.failure(info, ElementsShouldBeAtLeast.elementsShouldBeAtLeast(array, times, condition));
        }
    }

    public <E> void assertAreAtMost(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info, failures, conditions, array, condition);
        if (matchingElements.size() > times) {
            throw failures.failure(info, ElementsShouldBeAtMost.elementsShouldBeAtMost(array, times, condition));
        }
    }

    public <E> void assertAreExactly(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info, failures, conditions, array, condition);
        if (matchingElements.size() != times) {
            throw failures.failure(info, ElementsShouldBeExactly.elementsShouldBeExactly(array, times, condition));
        }
    }

    public <E> void assertHaveAtLeast(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info, failures, conditions, array, condition);
        if (matchingElements.size() < times) {
            throw failures.failure(info, ElementsShouldHaveAtLeast.elementsShouldHaveAtLeast(array, times, condition));
        }
    }

    public <E> void assertHaveAtMost(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info, failures, conditions, array, condition);
        if (matchingElements.size() > times) {
            throw failures.failure(info, ElementsShouldHaveAtMost.elementsShouldHaveAtMost(array, times, condition));
        }
    }

    public <E> void assertHaveExactly(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info, failures, conditions, array, condition);
        if (matchingElements.size() != times) {
            throw failures.failure(info, ElementsShouldHaveExactly.elementsShouldHaveExactly(array, times, condition));
        }
    }

    public void assertContainsAnyOf(AssertionInfo info, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info, actual, values)) {
            return;
        }
        Arrays.assertIsArray(info, actual);
        Arrays.assertIsArray(info, values);
        List valuesToSearchFor = Arrays.asList(values);
        for (Object element : Arrays.asList(actual)) {
            if (!this.iterableContains(valuesToSearchFor, element)) continue;
            return;
        }
        throw failures.failure(info, ShouldContainAnyOf.shouldContainAnyOf(actual, values, this.comparisonStrategy));
    }

    private <E> List<E> getElementsMatchingCondition(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        return this.filterElements(info, failures, conditions, array, condition, false);
    }

    private <E> List<E> getElementsNotMatchingCondition(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        return this.filterElements(info, failures, conditions, array, condition, true);
    }

    private <E> List<E> filterElements(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition, boolean negateCondition) throws AssertionError {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            LinkedList<Object> filteredElements = new LinkedList<Object>();
            int arraySize = org.assertj.core.util.Arrays.sizeOf(array);
            for (int i = 0; i < arraySize; ++i) {
                Object element = Array.get(array, i);
                if (negateCondition == condition.matches(element)) continue;
                filteredElements.add(element);
            }
            return filteredElements;
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    void assertIsSorted(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            Comparator<?> comparator = ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
            Arrays.assertIsSortedAccordingToComparator(info, failures, array, comparator);
            return;
        }
        if (org.assertj.core.util.Arrays.sizeOf(array) == 0) {
            return;
        }
        Arrays.assertThatArrayComponentTypeIsSortable(info, failures, array);
        try {
            Comparable<Object>[] comparableArray = Arrays.arrayOfComparableItems(array);
            if (comparableArray.length <= 1) {
                return;
            }
            for (int i = 0; i < comparableArray.length - 1; ++i) {
                if (comparableArray[i].compareTo(comparableArray[i + 1]) <= 0) continue;
                throw failures.failure(info, ShouldBeSorted.shouldBeSorted(i, array));
            }
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ShouldBeSorted.shouldHaveMutuallyComparableElements(array));
        }
    }

    static <T> void assertIsSortedAccordingToComparator(AssertionInfo info, Failures failures, Object array, Comparator<T> comparator) {
        Arrays.assertNotNull(info, array);
        java.util.Objects.requireNonNull(comparator, "The given comparator should not be null");
        try {
            List<T> arrayAsList = Arrays.asList(array);
            if (arrayAsList.size() == 0) {
                return;
            }
            if (arrayAsList.size() == 1) {
                comparator.compare(arrayAsList.get(0), arrayAsList.get(0));
                return;
            }
            for (int i = 0; i < arrayAsList.size() - 1; ++i) {
                if (comparator.compare(arrayAsList.get(i), arrayAsList.get(i + 1)) <= 0) continue;
                throw failures.failure(info, ShouldBeSorted.shouldBeSortedAccordingToGivenComparator(i, array, comparator));
            }
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ShouldBeSorted.shouldHaveComparableElementsAccordingToGivenComparator(array, comparator));
        }
    }

    private static <T> List<T> asList(Object array) {
        if (array == null) {
            return null;
        }
        Preconditions.checkArgument(org.assertj.core.util.Arrays.isArray(array), "The object should be an array", new Object[0]);
        int length = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    private static Comparable<Object>[] arrayOfComparableItems(Object array) {
        ArrayWrapperList arrayWrapperList = ArrayWrapperList.wrap(array);
        Comparable[] arrayOfComparableItems = new Comparable[arrayWrapperList.size()];
        for (int i = 0; i < arrayWrapperList.size(); ++i) {
            arrayOfComparableItems[i] = (Comparable)arrayWrapperList.get(i);
        }
        return arrayOfComparableItems;
    }

    private static void assertThatArrayComponentTypeIsSortable(AssertionInfo info, Failures failures, Object array) {
        ArrayWrapperList arrayAsList = ArrayWrapperList.wrap(array);
        Class<?> arrayComponentType = arrayAsList.getComponentType();
        if (arrayComponentType.isPrimitive()) {
            return;
        }
        if (!Comparable.class.isAssignableFrom(arrayComponentType)) {
            throw failures.failure(info, ShouldBeSorted.shouldHaveMutuallyComparableElements(array));
        }
    }

    private static void checkIsNotNullAndNotEmpty(Object values) {
        Arrays.checkIsNotNull(values);
        if (Arrays.isArrayEmpty(values)) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private static void checkIsNotNull(Object values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    static boolean isArrayEmpty(Object array) {
        return org.assertj.core.util.Arrays.sizeOf(array) == 0;
    }

    private AssertionError arrayDoesNotEndWithSequence(AssertionInfo info, Failures failures, Object array, Object sequence) {
        return failures.failure(info, ShouldEndWith.shouldEndWith(array, sequence, this.comparisonStrategy));
    }

    static void assertNotNull(AssertionInfo info, Object array) {
        Objects.instance().assertNotNull(info, array);
    }

    private static void failIfEmptySinceActualIsNotEmpty(Object values) {
        if (Arrays.isArrayEmpty(values)) {
            throw new AssertionError((Object)"actual is not empty while group of values to look for is.");
        }
    }
}

