/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.services;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ObjectSaverToDiskService {
    private static final Logger log = LoggerFactory.getLogger(ObjectSaverToDiskService.class);
    private static final String regexInvalidCharInFileName = "[\\\\/:*?\"<>|]";
    private final ObjectWriter writer;
    private final FileService fileService;

    public ObjectSaverToDiskService(FileService fileService, @Value(value="${atp.export.pretty-print:false}") boolean isPrettyPrint) {
        this.writer = isPrettyPrint ? new ObjectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter()) : new ObjectMapper().writer();
        this.fileService = fileService;
    }

    public void exportAtpEntity(UUID id, Object object, Path dir) throws ExportException {
        this.exportAtpEntity(id, object, null, dir);
    }

    public void exportAtpEntity(UUID id, Object object, UUID parentId, Path dir) throws ExportException {
        Assert.notNull((Object)id, (String)"Id cannot be null");
        Assert.notNull((Object)object, (String)"Object cannot be null");
        Path testScopesDirPath = this.fileService.createDirectory(object.getClass().getSimpleName(), dir);
        this.writeAtpEntityToFile(id, object, parentId, testScopesDirPath);
    }

    public void writeAtpEntityToFile(UUID id, Object object, Path dir) throws ExportException {
        this.writeAtpEntityToFile(id, object, null, dir);
    }

    public void writeAtpEntityToFile(UUID id, Object object, UUID parentId, Path dir) throws ExportException {
        this.writeAtpEntityToFile(id.toString(), object, parentId == null ? null : parentId.toString(), dir, false);
    }

    public void writeAtpEntityToFile(@NotNull String fileName, @NotNull Object object, String parentName, @NotNull Path dir, boolean validateFileName) throws ExportException {
        fileName = validateFileName ? fileName.replaceAll(regexInvalidCharInFileName, "") : fileName;
        Path filePath = dir;
        if (Strings.isNotBlank((String)parentName)) {
            filePath = this.fileService.createDirectory(parentName, filePath);
        }
        filePath = this.fileService.createFile(fileName + ".json", filePath);
        this.writeObject(filePath, object);
    }

    private void writeObject(Path filePath, Object object) throws ExportException {
        try {
            this.writer.writeValue(filePath.toFile(), object);
        }
        catch (IOException ex) {
            log.error("Cannot write object {} in file {}", new Object[]{object, filePath.toString(), ex});
            ExportException.throwException("Cannot write object {} in file ", object, filePath.toString(), ex);
        }
    }
}

