/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.services.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.qubership.atp.ei.node.CancellableExportImportTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Service
public class TasksService {
    private static final Logger log = LoggerFactory.getLogger(TasksService.class);
    private static final Map<String, Future<Object>> tasks = new HashMap<String, Future<Object>>();

    public Future<Object> getTaskById(String taskId) {
        return tasks.get(taskId);
    }

    public void cancelTask(String taskId) {
        Future<Object> task = tasks.get(taskId);
        if (task != null) {
            task.cancel(true);
        }
    }

    public void submitTask(String taskId, CancellableExportImportTask executor, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        ListenableFuture task = threadPoolTaskExecutor.submitListenable((Callable)executor);
        task.addCallback((ListenableFutureCallback)new CleanTaskListCallback(taskId));
        task.addCallback((ListenableFutureCallback)new MarkTaskAsCancelled(executor));
        tasks.put(taskId, (Future<Object>)task);
    }

    private static class CleanTaskListCallback
    implements ListenableFutureCallback<Object> {
        private final String taskId;

        CleanTaskListCallback(String taskId) {
            this.taskId = taskId;
        }

        public void onFailure(Throwable thr) {
            tasks.remove(this.taskId);
        }

        public void onSuccess(Object o) {
            tasks.remove(this.taskId);
        }
    }

    private static class MarkTaskAsCancelled
    implements ListenableFutureCallback<Object> {
        private final CancellableExportImportTask task;

        MarkTaskAsCancelled(CancellableExportImportTask task) {
            this.task = task;
        }

        public void onFailure(Throwable thr) {
            this.task.setCancelled();
        }

        public void onSuccess(Object o) {
        }
    }
}

