/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.ssl;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.springframework.beans.factory.annotation.Autowired;

public class KeyStoreProvider
implements Provider<KeyStore> {
    private static final String CERTIFICATE_ALIAS = "certificate";
    @Autowired
    private Provider<List<Certificate>> certificateProvider;
    private KeyStore keyStore;

    @Override
    public KeyStore get() {
        if (Objects.isNull(this.keyStore)) {
            this.keyStore = this.createKeyStore();
        }
        return this.keyStore;
    }

    private KeyStore createKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            for (Certificate certificate : this.certificateProvider.get()) {
                keyStore.setCertificateEntry(CERTIFICATE_ALIAS + UUID.randomUUID().toString(), certificate);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create key store.", e);
        }
    }
}

