/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.support;

import au.com.dius.pact.core.support.CustomServiceUnavailableRetryStrategy;
import au.com.dius.pact.core.support.HttpClient;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lau/com/dius/pact/core/support/HttpClient;", "Lmu/KLogging;", "()V", "newHttpClient", "Lkotlin/Pair;", "Lorg/apache/http/impl/client/CloseableHttpClient;", "Lorg/apache/http/client/CredentialsProvider;", "options", "", "uri", "Ljava/net/URI;", "defaultHeaderStore", "", "", "maxPublishRetries", "", "publishRetryInterval", "support"})
public final class HttpClient
extends KLogging {
    public static final HttpClient INSTANCE;

    @NotNull
    public final Pair<CloseableHttpClient, CredentialsProvider> newHttpClient(@Nullable Object options, @NotNull URI uri, @NotNull Map<String, String> defaultHeaderStore, int maxPublishRetries, int publishRetryInterval) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull(defaultHeaderStore, (String)"defaultHeaderStore");
        CustomServiceUnavailableRetryStrategy retryStrategy = new CustomServiceUnavailableRetryStrategy(maxPublishRetries, publishRetryInterval);
        HttpClientBuilder builder = HttpClients.custom().useSystemProperties().setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)retryStrategy);
        CredentialsProvider credsProvider = null;
        if (options instanceof List) {
            String string = String.valueOf(CollectionsKt.first((List)((List)options)));
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String scheme = string3;
            if (Intrinsics.areEqual((Object)scheme, (Object)"basic")) {
                if (((List)options).size() > 2) {
                    credsProvider = (CredentialsProvider)new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(String.valueOf(((List)options).get(1)), String.valueOf(((List)options).get(2))));
                    builder.setDefaultCredentialsProvider(credsProvider);
                } else {
                    this.getLogger().warn((Function0)newHttpClient.1.INSTANCE);
                }
            } else if (Intrinsics.areEqual((Object)scheme, (Object)"bearer")) {
                if (((List)options).size() > 1) {
                    defaultHeaderStore.put("Authorization", "Bearer " + String.valueOf(((List)options).get(1)));
                } else {
                    this.getLogger().warn((Function0)newHttpClient.2.INSTANCE);
                }
            } else {
                this.getLogger().warn((Function0)new Function0<String>(scheme){
                    final /* synthetic */ String $scheme;

                    @NotNull
                    public final String invoke() {
                        return "HTTP client Only supports basic and bearer token authentication, got '" + this.$scheme + "', ignoring.";
                    }
                    {
                        this.$scheme = string;
                        super(0);
                    }
                });
            }
        }
        return TuplesKt.to((Object)builder.build(), (Object)credsProvider);
    }

    public static /* synthetic */ Pair newHttpClient$default(HttpClient httpClient, Object object, URI uRI, Map map, int n, int n2, int n3, Object object2) {
        if ((n3 & 8) != 0) {
            n = 5;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 3000;
        }
        return httpClient.newHttpClient(object, uRI, map, n, n2);
    }

    private HttpClient() {
    }

    static {
        HttpClient httpClient;
        INSTANCE = httpClient = new HttpClient();
    }
}

