/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.support.expressions;

import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\t"}, d2={"Lau/com/dius/pact/core/support/expressions/SystemPropertyResolver;", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "()V", "propertyDefined", "", "property", "", "resolveValue", "PropertyValueTuple", "support"})
public final class SystemPropertyResolver
implements ValueResolver {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String resolveValue(@Nullable String property) {
        String string;
        PropertyValueTuple tuple = new PropertyValueTuple(property).invoke();
        if (KotlinLanguageSupportKt.isNotEmpty(property)) {
            void var3_3;
            String propertyValue;
            String string2 = tuple.getPropertyName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if ((propertyValue = System.getProperty(string2)) == null) {
                propertyValue = System.getenv(tuple.getPropertyName());
            }
            if (propertyValue == null) {
                propertyValue = tuple.getDefaultValue();
            }
            if (propertyValue == null) {
                throw (Throwable)new RuntimeException("Could not resolve property \"" + tuple.getPropertyName() + "\" in the system properties or " + "environment variables and no default value is supplied");
            }
            string = var3_3;
        } else {
            string = property;
        }
        return string;
    }

    @Override
    public boolean propertyDefined(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        String propertyValue = System.getProperty(property);
        if (propertyValue == null) {
            propertyValue = System.getenv(property);
        }
        return propertyValue != null;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0000H\u0086\u0002R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\f"}, d2={"Lau/com/dius/pact/core/support/expressions/SystemPropertyResolver$PropertyValueTuple;", "", "property", "", "(Ljava/lang/String;)V", "<set-?>", "defaultValue", "getDefaultValue", "()Ljava/lang/String;", "propertyName", "getPropertyName", "invoke", "support"})
    public static final class PropertyValueTuple {
        @Nullable
        private String propertyName;
        @Nullable
        private String defaultValue;

        @Nullable
        public final String getPropertyName() {
            return this.propertyName;
        }

        @Nullable
        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @NotNull
        public final PropertyValueTuple invoke() {
            if (KotlinLanguageSupportKt.contains(this.propertyName, ":")) {
                String[] kv = StringUtils.splitPreserveAllTokens((String)this.propertyName, (char)':');
                this.propertyName = kv[0];
                if (kv.length > 1) {
                    this.defaultValue = kv[1];
                }
            }
            return this;
        }

        public PropertyValueTuple(@Nullable String property) {
            this.propertyName = property;
            this.defaultValue = null;
        }
    }
}

