/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.support.json;

import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.json.JsonValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\b\"#$%&'()B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\nJ\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0001H\u0086\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\nJ\b\u0010!\u001a\u0004\u0018\u00010\u0001R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0011\u0010\b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\b*+,-./\u0011\u0016\u00a8\u00060"}, d2={"Lau/com/dius/pact/core/support/json/JsonValue;", "", "()V", "isBoolean", "", "()Z", "isNull", "isNumber", "isString", "name", "", "getName", "()Ljava/lang/String;", "add", "", "value", "asArray", "Lau/com/dius/pact/core/support/json/JsonValue$Array;", "asBoolean", "asNumber", "", "asObject", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "asString", "get", "field", "has", "serialise", "size", "", "toGson", "Lcom/google/gson/JsonElement;", "type", "unwrap", "Array", "Decimal", "False", "Integer", "Null", "Object", "StringValue", "True", "Lau/com/dius/pact/core/support/json/JsonValue$Integer;", "Lau/com/dius/pact/core/support/json/JsonValue$Decimal;", "Lau/com/dius/pact/core/support/json/JsonValue$StringValue;", "Lau/com/dius/pact/core/support/json/JsonValue$True;", "Lau/com/dius/pact/core/support/json/JsonValue$False;", "Lau/com/dius/pact/core/support/json/JsonValue$Null;", "support"})
public abstract class JsonValue {
    @NotNull
    public final Object asObject() {
        if (this instanceof Object) {
            return (Object)this;
        }
        throw (Throwable)new UnsupportedOperationException("Expected an Object, but found a " + this);
    }

    @NotNull
    public final Array asArray() {
        if (this instanceof Array) {
            return (Array)this;
        }
        throw (Throwable)new UnsupportedOperationException("Expected an Array, but found a " + this);
    }

    @NotNull
    public final String asString() {
        return this instanceof StringValue ? ((StringValue)this).getValue() : this.serialise();
    }

    public final boolean asBoolean() {
        boolean bl;
        JsonValue jsonValue = this;
        if (jsonValue instanceof True) {
            bl = true;
        } else if (jsonValue instanceof False) {
            bl = false;
        } else {
            throw (Throwable)new UnsupportedOperationException("Expected a Boolean, but found a " + this);
        }
        return bl;
    }

    @NotNull
    public final Number asNumber() {
        Number number;
        JsonValue jsonValue = this;
        if (jsonValue instanceof Integer) {
            number = ((Integer)this).getValue();
        } else if (jsonValue instanceof Decimal) {
            number = ((Decimal)this).getValue();
        } else {
            throw (Throwable)new UnsupportedOperationException("Expected a Number, but found a " + this);
        }
        return number;
    }

    @NotNull
    public final JsonValue get(@NotNull java.lang.Object field) {
        JsonValue jsonValue;
        Intrinsics.checkParameterIsNotNull((java.lang.Object)field, (String)"field");
        if (this instanceof Object) {
            jsonValue = this.asObject().get(field.toString());
        } else if (this instanceof Array && field instanceof java.lang.Integer) {
            jsonValue = ((Array)this).getValues().get(((Number)field).intValue());
        } else {
            throw (Throwable)new UnsupportedOperationException("Indexed lookups only work on Arrays and Objects, not " + this);
        }
        return jsonValue;
    }

    public boolean has(@NotNull String field) {
        Intrinsics.checkParameterIsNotNull((java.lang.Object)field, (String)"field");
        JsonValue jsonValue = this;
        return jsonValue instanceof Object ? ((Object)this).getEntries().containsKey(field) : false;
    }

    @NotNull
    public final String serialise() {
        String string;
        JsonValue jsonValue = this;
        if (jsonValue instanceof Null) {
            string = "null";
        } else if (jsonValue instanceof Decimal) {
            String string2 = ((Decimal)this).getValue().toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((java.lang.Object)string2, (String)"this.value.toString()");
        } else if (jsonValue instanceof Integer) {
            String string3 = ((Integer)this).getValue().toString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((java.lang.Object)string3, (String)"this.value.toString()");
        } else if (jsonValue instanceof StringValue) {
            string = '\"' + StringEscapeUtils.escapeJson((String)((StringValue)this).getValue()) + '\"';
        } else if (jsonValue instanceof True) {
            string = "true";
        } else if (jsonValue instanceof False) {
            string = "false";
        } else if (jsonValue instanceof Array) {
            string = '[' + CollectionsKt.joinToString$default((Iterable)((Array)this).getValues(), (CharSequence)",", null, null, (int)0, null, (Function1)serialise.1.INSTANCE, (int)30, null) + ']';
        } else if (jsonValue instanceof Object) {
            string = '{' + CollectionsKt.joinToString$default((Iterable)((Object)this).getEntries().entrySet(), (CharSequence)",", null, null, (int)0, null, (Function1)serialise.2.INSTANCE, (int)30, null) + '}';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final JsonElement toGson() {
        JsonElement jsonElement;
        JsonValue jsonValue = this;
        if (jsonValue instanceof Null) {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((java.lang.Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        } else if (jsonValue instanceof Decimal) {
            jsonElement = (JsonElement)new JsonPrimitive((Number)((Decimal)this).getValue());
        } else if (jsonValue instanceof Integer) {
            jsonElement = (JsonElement)new JsonPrimitive((Number)((Integer)this).getValue());
        } else if (jsonValue instanceof StringValue) {
            jsonElement = (JsonElement)new JsonPrimitive(((StringValue)this).getValue());
        } else if (jsonValue instanceof True) {
            jsonElement = (JsonElement)new JsonPrimitive(Boolean.valueOf(true));
        } else if (jsonValue instanceof False) {
            jsonElement = (JsonElement)new JsonPrimitive(Boolean.valueOf(false));
        } else if (jsonValue instanceof Array) {
            JsonArray array = new JsonArray();
            Iterable $this$forEach$iv = ((Array)this).getValues();
            boolean $i$f$forEach = false;
            for (java.lang.Object element$iv : $this$forEach$iv) {
                JsonValue it = (JsonValue)element$iv;
                boolean bl = false;
                array.add(it.toGson());
            }
            jsonElement = (JsonElement)array;
        } else if (jsonValue instanceof Object) {
            JsonObject obj = new JsonObject();
            Map<String, JsonValue> $this$forEach$iv = ((Object)this).getEntries();
            boolean $i$f$forEach = false;
            Map<String, JsonValue> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, JsonValue>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonValue> element$iv;
                Map.Entry<String, JsonValue> it = element$iv = iterator.next();
                boolean bl2 = false;
                obj.add(it.getKey(), it.getValue().toGson());
            }
            jsonElement = (JsonElement)obj;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonElement;
    }

    public final void add(@NotNull JsonValue value) {
        Intrinsics.checkParameterIsNotNull((java.lang.Object)value, (String)"value");
        if (!(this instanceof Array)) {
            throw (Throwable)new UnsupportedOperationException("You can only add single values to Arrays, not " + this);
        }
        ((Array)this).getValues().add(value);
    }

    public final int size() {
        JsonValue jsonValue = this;
        return jsonValue instanceof Array ? ((Array)this).getValues().size() : (jsonValue instanceof Object ? ((Object)this).getEntries().size() : 1);
    }

    @NotNull
    public final String type() {
        String string;
        JsonValue jsonValue = this;
        if (jsonValue instanceof StringValue) {
            string = "String";
        } else {
            String string2 = this.getClass().getSimpleName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((java.lang.Object)string2, (String)"this::class.java.simpleName");
        }
        return string;
    }

    @Nullable
    public final java.lang.Object unwrap() {
        java.lang.Object object;
        JsonValue jsonValue = this;
        if (jsonValue instanceof Null) {
            object = null;
        } else if (jsonValue instanceof Decimal) {
            object = ((Decimal)this).getValue();
        } else if (jsonValue instanceof Integer) {
            object = ((Integer)this).getValue();
        } else if (jsonValue instanceof StringValue) {
            object = ((StringValue)this).getValue();
        } else if (jsonValue instanceof True) {
            object = true;
        } else if (jsonValue instanceof False) {
            object = false;
        } else if (jsonValue instanceof Array) {
            object = ((Array)this).getValues();
        } else if (jsonValue instanceof Object) {
            object = ((Object)this).getEntries();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final String getName() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((java.lang.Object)string, (String)"this.javaClass.simpleName");
        return string;
    }

    public final boolean isBoolean() {
        JsonValue jsonValue = this;
        return jsonValue instanceof True || jsonValue instanceof False;
    }

    public final boolean isNumber() {
        JsonValue jsonValue = this;
        return jsonValue instanceof Integer || jsonValue instanceof Decimal;
    }

    public final boolean isString() {
        JsonValue jsonValue = this;
        return jsonValue instanceof StringValue;
    }

    public final boolean isNull() {
        JsonValue jsonValue = this;
        return jsonValue instanceof Null;
    }

    private JsonValue() {
    }

    public /* synthetic */ JsonValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lau/com/dius/pact/core/support/json/JsonValue$Integer;", "Lau/com/dius/pact/core/support/json/JsonValue;", "value", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "getValue", "()Ljava/math/BigInteger;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "support"})
    public static final class Integer
    extends JsonValue {
        @NotNull
        private final BigInteger value;

        @NotNull
        public final BigInteger getValue() {
            return this.value;
        }

        public Integer(@NotNull BigInteger value) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final BigInteger component1() {
            return this.value;
        }

        @NotNull
        public final Integer copy(@NotNull BigInteger value) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)value, (String)"value");
            return new Integer(value);
        }

        public static /* synthetic */ Integer copy$default(Integer integer, BigInteger bigInteger, int n, java.lang.Object object) {
            if ((n & 1) != 0) {
                bigInteger = integer.value;
            }
            return integer.copy(bigInteger);
        }

        @NotNull
        public String toString() {
            return "Integer(value=" + this.value + ")";
        }

        public int hashCode() {
            BigInteger bigInteger = this.value;
            return bigInteger != null ? ((java.lang.Object)bigInteger).hashCode() : 0;
        }

        public boolean equals(@Nullable java.lang.Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Integer)) break block3;
                    Integer integer = (Integer)object;
                    if (!Intrinsics.areEqual((java.lang.Object)this.value, (java.lang.Object)integer.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lau/com/dius/pact/core/support/json/JsonValue$Decimal;", "Lau/com/dius/pact/core/support/json/JsonValue;", "value", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "getValue", "()Ljava/math/BigDecimal;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "support"})
    public static final class Decimal
    extends JsonValue {
        @NotNull
        private final BigDecimal value;

        @NotNull
        public final BigDecimal getValue() {
            return this.value;
        }

        public Decimal(@NotNull BigDecimal value) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final BigDecimal component1() {
            return this.value;
        }

        @NotNull
        public final Decimal copy(@NotNull BigDecimal value) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)value, (String)"value");
            return new Decimal(value);
        }

        public static /* synthetic */ Decimal copy$default(Decimal decimal, BigDecimal bigDecimal, int n, java.lang.Object object) {
            if ((n & 1) != 0) {
                bigDecimal = decimal.value;
            }
            return decimal.copy(bigDecimal);
        }

        @NotNull
        public String toString() {
            return "Decimal(value=" + this.value + ")";
        }

        public int hashCode() {
            BigDecimal bigDecimal = this.value;
            return bigDecimal != null ? ((java.lang.Object)bigDecimal).hashCode() : 0;
        }

        public boolean equals(@Nullable java.lang.Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Decimal)) break block3;
                    Decimal decimal = (Decimal)object;
                    if (!Intrinsics.areEqual((java.lang.Object)this.value, (java.lang.Object)decimal.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lau/com/dius/pact/core/support/json/JsonValue$StringValue;", "Lau/com/dius/pact/core/support/json/JsonValue;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "support"})
    public static final class StringValue
    extends JsonValue {
        @NotNull
        private final String value;

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public StringValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final StringValue copy(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)value, (String)"value");
            return new StringValue(value);
        }

        public static /* synthetic */ StringValue copy$default(StringValue stringValue, String string, int n, java.lang.Object object) {
            if ((n & 1) != 0) {
                string = stringValue.value;
            }
            return stringValue.copy(string);
        }

        @NotNull
        public String toString() {
            return "StringValue(value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.value;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable java.lang.Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StringValue)) break block3;
                    StringValue stringValue = (StringValue)object;
                    if (!Intrinsics.areEqual((java.lang.Object)this.value, (java.lang.Object)stringValue.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/core/support/json/JsonValue$True;", "Lau/com/dius/pact/core/support/json/JsonValue;", "()V", "support"})
    public static final class True
    extends JsonValue {
        public static final True INSTANCE;

        private True() {
            super(null);
        }

        static {
            True true_;
            INSTANCE = true_ = new True();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/core/support/json/JsonValue$False;", "Lau/com/dius/pact/core/support/json/JsonValue;", "()V", "support"})
    public static final class False
    extends JsonValue {
        public static final False INSTANCE;

        private False() {
            super(null);
        }

        static {
            False false_;
            INSTANCE = false_ = new False();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/core/support/json/JsonValue$Null;", "Lau/com/dius/pact/core/support/json/JsonValue;", "()V", "support"})
    public static final class Null
    extends JsonValue {
        public static final Null INSTANCE;

        private Null() {
            super(null);
        }

        static {
            Null nullVal;
            INSTANCE = nullVal = new Null();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u0019\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0016J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010\u0018\u001a\u00020\u0001J\u0019\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0001H\u0086\u0002J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lau/com/dius/pact/core/support/json/JsonValue$Array;", "Lau/com/dius/pact/core/support/json/JsonValue;", "values", "", "(Ljava/util/List;)V", "size", "", "getSize", "()I", "getValues", "()Ljava/util/List;", "addAll", "", "jsonValue", "component1", "copy", "equals", "", "other", "", "find", "function", "Lkotlin/Function1;", "hashCode", "last", "set", "i", "value", "toString", "", "support"})
    public static final class Array
    extends JsonValue {
        @NotNull
        private final List<JsonValue> values;

        @Nullable
        public final JsonValue find(@NotNull Function1<? super JsonValue, Boolean> function) {
            java.lang.Object v0;
            block1: {
                Intrinsics.checkParameterIsNotNull(function, (String)"function");
                Iterable iterable = this.values;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (java.lang.Object t : iterable2) {
                    if (!((Boolean)function.invoke(t)).booleanValue()) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public final void set(int i, @NotNull JsonValue value) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)value, (String)"value");
            this.values.set(i, value);
        }

        public final int getSize() {
            return this.values.size();
        }

        public final void addAll(@NotNull JsonValue jsonValue) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)jsonValue, (String)"jsonValue");
            JsonValue jsonValue2 = jsonValue;
            if (jsonValue2 instanceof Array) {
                this.values.addAll((Collection<JsonValue>)((Array)jsonValue).values);
            } else {
                this.values.add(jsonValue);
            }
        }

        @NotNull
        public final JsonValue last() {
            return (JsonValue)CollectionsKt.last(this.values);
        }

        @NotNull
        public final List<JsonValue> getValues() {
            return this.values;
        }

        public Array(@NotNull List<JsonValue> values) {
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            super(null);
            this.values = values;
        }

        public /* synthetic */ Array(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                boolean bl = false;
                list = new ArrayList();
            }
            this(list);
        }

        public Array() {
            this(null, 1, null);
        }

        @NotNull
        public final List<JsonValue> component1() {
            return this.values;
        }

        @NotNull
        public final Array copy(@NotNull List<JsonValue> values) {
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            return new Array(values);
        }

        public static /* synthetic */ Array copy$default(Array array, List list, int n, java.lang.Object object) {
            if ((n & 1) != 0) {
                list = array.values;
            }
            return array.copy(list);
        }

        @NotNull
        public String toString() {
            return "Array(values=" + this.values + ")";
        }

        public int hashCode() {
            List<JsonValue> list = this.values;
            return list != null ? ((java.lang.Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable java.lang.Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Array)) break block3;
                    Array array = (Array)object;
                    if (!Intrinsics.areEqual(this.values, array.values)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B3\b\u0016\u0012*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\u0003\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0006B\u0019\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0001J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\bH\u00c6\u0003J\u001f\u0010\u0015\u001a\u00020\u00002\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\u0011\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\t\u0010\u001e\u001a\u00020\rH\u00d6\u0001J\u0006\u0010\u001f\u001a\u00020\u0017J\u0006\u0010 \u001a\u00020\u0017J\u001b\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0019H\u0086\u0002J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lau/com/dius/pact/core/support/json/JsonValue$Object;", "Lau/com/dius/pact/core/support/json/JsonValue;", "values", "", "Lkotlin/Pair;", "", "([Lkotlin/Pair;)V", "entries", "", "(Ljava/util/Map;)V", "getEntries", "()Ljava/util/Map;", "size", "", "getSize", "()I", "add", "", "key", "value", "component1", "copy", "equals", "", "other", "", "get", "name", "has", "field", "hashCode", "isEmpty", "isNotEmpty", "set", "toString", "support"})
    public static final class Object
    extends JsonValue {
        @NotNull
        private final Map<String, JsonValue> entries;

        @NotNull
        public final JsonValue get(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)name, (String)"name");
            JsonValue jsonValue = this.entries.get(name);
            if (jsonValue == null) {
                jsonValue = Null.INSTANCE;
            }
            return jsonValue;
        }

        @Override
        public boolean has(@NotNull String field) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)field, (String)"field");
            return this.entries.containsKey(field);
        }

        public final void set(@NotNull String key, @Nullable java.lang.Object value) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)key, (String)"key");
            this.entries.put(key, Json.INSTANCE.toJson(value));
        }

        public final boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public final boolean isNotEmpty() {
            Map<String, JsonValue> map = this.entries;
            boolean bl = false;
            return !map.isEmpty();
        }

        public final int getSize() {
            return this.entries.size();
        }

        public final void add(@NotNull String key, @NotNull JsonValue value) {
            Intrinsics.checkParameterIsNotNull((java.lang.Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((java.lang.Object)value, (String)"value");
            this.entries.put(key, value);
        }

        @NotNull
        public final Map<String, JsonValue> getEntries() {
            return this.entries;
        }

        public Object(@NotNull Map<String, JsonValue> entries) {
            Intrinsics.checkParameterIsNotNull(entries, (String)"entries");
            super(null);
            this.entries = entries;
        }

        /*
         * WARNING - void declaration
         */
        public Object(Pair<String, ? extends JsonValue> ... values) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Pair<String, ? extends JsonValue>[] pairArray = values;
            Object object = this;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associate$iv).length), (int)16);
            void var5_6 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (void element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                void it = element$iv$iv;
                boolean bl = false;
                void var13_14 = it;
                boolean bl2 = false;
                map.put(var13_14.getFirst(), var13_14.getSecond());
            }
            Map map = destination$iv$iv;
            object(MapsKt.toMutableMap((Map)map));
        }

        @NotNull
        public final Map<String, JsonValue> component1() {
            return this.entries;
        }

        @NotNull
        public final Object copy(@NotNull Map<String, JsonValue> entries) {
            Intrinsics.checkParameterIsNotNull(entries, (String)"entries");
            return new Object(entries);
        }

        public static /* synthetic */ Object copy$default(Object object, Map map, int n, java.lang.Object object2) {
            if ((n & 1) != 0) {
                map = object.entries;
            }
            return object.copy(map);
        }

        @NotNull
        public String toString() {
            return "Object(entries=" + this.entries + ")";
        }

        public int hashCode() {
            Map<String, JsonValue> map = this.entries;
            return map != null ? ((java.lang.Object)map).hashCode() : 0;
        }

        public boolean equals(@Nullable java.lang.Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Object)) break block3;
                    Object object2 = (Object)object;
                    if (!Intrinsics.areEqual(this.entries, object2.entries)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

