/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.decorators;

import java.util.Map;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;

public class MdcTaskDecorator
implements TaskDecorator {
    public Runnable decorate(Runnable runnable) {
        Map contextMap = MDC.getCopyOfContextMap();
        return () -> {
            try {
                if (contextMap != null) {
                    MDC.setContextMap((Map)contextMap);
                }
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        };
    }
}

