/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import java.util.function.Supplier;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;

public class RefToRefTestData {

    public static class TwoRefsToTheSameRandom
    implements Supplier<VisibilityArea> {
        public final VisibilityArea va;
        public final DataSetList dsl;
        public final DataSet ds;
        public final DataSetList paramsDsl;
        public final DataSet paramsDs;
        public final String macro = "IP_AccessServiceOrderItemSpec_#REF_DSL(Params.DEFAULT_SMF_IqSP.CRM)";
        public final Parameter dsIntoParams;
        public final Parameter crm;
        public final Parameter keyB;
        public final Parameter keyA;

        public TwoRefsToTheSameRandom(CreationFacade create, AliasWrapperService wrapperService) {
            this.va = create.va("ATPII-4102");
            this.dsl = create.dsl(this.va, "SMF IqSP");
            this.ds = create.ds(this.dsl, "Automatic PzT WS (SDSL, 3, Montage_mit_Kundenanwesenheit)");
            this.paramsDsl = create.dsl(this.va, "Params");
            this.paramsDs = create.ds(this.paramsDsl, "DEFAULT_SMF_IqSP");
            this.dsIntoParams = create.refParam(this.ds, this.paramsDs);
            this.crm = create.textParam(this.paramsDs, "CRM", "#RANDOMBETWEEN(30000000, 39999999)");
            String wrappedMacro = wrapperService.wrapToAlias("IP_AccessServiceOrderItemSpec_#REF_DSL(Params.DEFAULT_SMF_IqSP.CRM)", this.va, this.dsl);
            this.keyA = create.textParam(this.paramsDs, "keyA", wrappedMacro);
            this.keyB = create.textParam(this.paramsDs, "keyB", wrappedMacro);
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }

    public static class RefDslChildRefTargetParamIsInitialized
    extends ChildRefParamIsInitialized {
        public final Parameter parentRef;

        public RefDslChildRefTargetParamIsInitialized(CreationFacade create) {
            super(create);
            create.textParam(this.currentCase, "Capital", "test");
            this.parentRef = create.textParam(this.currentCase, "ParentRef", "#REF_DSL(Country.Belgium.ChildRef)");
        }
    }

    public static class RefThisChildRefTargetParamIsInitialized
    extends ChildRefParamIsInitialized {
        public final Parameter currentCaseIntoBelgium;
        public final Parameter parentRef;

        public RefThisChildRefTargetParamIsInitialized(CreationFacade create) {
            super(create);
            this.currentCaseIntoBelgium = create.refParam(this.currentCase, this.belgium);
            this.parentRef = create.textParam(this.currentCase, "ParentRef", "#REF_THIS(Country.ChildRef)");
        }
    }

    public static class ChildRefTargetParamIsOverlapped
    extends RefTargetParamIsOverlapped {
        public final Parameter parentRef;

        public ChildRefTargetParamIsOverlapped(CreationFacade create) {
            super(create);
            this.parentRef = create.textParam(this.currentCase, "ParentRef", "#REF_THIS(Country.ChildRef)");
        }
    }

    public static class RefTargetParamIsOverlapped
    extends AbstractCase {
        public final Parameter currentCaseIntoBelgium;
        public final Attribute capital;
        public final Parameter testCapital;
        public final Parameter childRef;
        public final Parameter brussels;

        public RefTargetParamIsOverlapped(CreationFacade create) {
            super(create);
            this.currentCaseIntoBelgium = create.refParam(this.currentCase, this.belgium);
            this.capital = create.textAttr(this.country, "Capital");
            this.testCapital = create.textParam(this.belgium, this.capital, "test");
            this.childRef = create.textParam(this.belgium, "ChildRef", "#REF_THIS(Capital)");
            this.brussels = create.overrideParam(this.currentCase, this.capital, "Brussels", null, null, null, new Attribute[]{this.currentCaseIntoBelgium.getAttribute()});
        }
    }

    public static class ChildRefIsOverlapped
    extends AbstractCase {
        public final Parameter currentCaseIntoBelgium;
        public final Attribute capital;
        public final Parameter childRef;
        public final Parameter origChildRef;
        public final Parameter brussels;
        public final Parameter parentRef;

        public ChildRefIsOverlapped(CreationFacade create) {
            super(create);
            this.currentCaseIntoBelgium = create.refParam(this.currentCase, this.belgium);
            this.capital = create.textAttr(this.country, "Capital");
            this.brussels = create.textParam(this.belgium, this.capital, "Brussels");
            this.origChildRef = create.textParam(this.belgium, "ChildRef", "#REF_THIS(Capital)");
            this.parentRef = create.textParam(this.currentCase, "ParentRef", "#REF_THIS(Country.ChildRef)");
            this.childRef = create.overrideParam(this.currentCase, this.origChildRef.getAttribute(), "#REF_THIS(Capital)", null, null, null, new Attribute[]{this.currentCaseIntoBelgium.getAttribute()});
        }
    }

    public static class VoiceCaseRefToDslWithOverlap
    implements Supplier<VisibilityArea> {
        public final VisibilityArea va;
        public final DataSetList subscription;
        public final DataSet proContact;
        public final Parameter tariffName;
        public final DataSetList country;
        public final DataSet usa;
        public final Parameter internationalZone;
        public final DataSetList voiceCases;
        public final DataSet belToUsa;
        public final Parameter usageType;
        public final Parameter belToUsaIntoSubscriptionRef;
        public final Parameter belToUsaIntoCountryRef;
        public final DataSetList internationalRatingZones;
        public final DataSet belgium;
        public final Parameter belgiumToUsaRating;
        public final DataSetList internationalVoiceRates;
        public final DataSet proContactRates;
        public final Parameter voiceRatesIntoRatingZoneRef;
        public final Parameter belgiumToUsaRatingOverlap;

        public VoiceCaseRefToDslWithOverlap(CreationFacade create) {
            this.va = create.va("ATPII-3231");
            this.subscription = create.dsl(this.va, "Subscription");
            this.proContact = create.ds(this.subscription, "Pro Contact");
            this.tariffName = create.textParam(this.proContact, "TariffName", "Pro Contact");
            this.country = create.dsl(this.va, "Country");
            this.usa = create.ds(this.country, "USA - USA/Canada");
            this.internationalZone = create.textParam(this.usa, "IntenationalZone", "USA / Canada");
            this.voiceCases = create.dsl(this.va, "Voice cases");
            this.belToUsa = create.ds(this.voiceCases, "TLNT-SOHO-CONTACT-VOICE-007 - Voice MO to USA/Canada number");
            this.usageType = create.textParam(this.belToUsa, "UsageType", "Voice Mobile");
            this.belToUsaIntoSubscriptionRef = create.refParam(this.belToUsa, "Subscription", this.proContact);
            this.belToUsaIntoCountryRef = create.refParam(this.belToUsa, "DestinationCountry", this.usa);
            this.internationalRatingZones = create.dsl(this.va, "International Rating Zones");
            this.belgium = create.ds(this.internationalRatingZones, "Belgium");
            this.belgiumToUsaRating = create.textParam(this.belgium, "USA / Canada", "");
            this.internationalVoiceRates = create.dsl(this.va, "International Voice Rates");
            this.proContactRates = create.ds(this.internationalVoiceRates, "Pro Contact");
            this.voiceRatesIntoRatingZoneRef = create.refParam(this.proContactRates, "Voice Mobile", this.belgium);
            this.belgiumToUsaRatingOverlap = create.overrideParam(this.proContactRates, this.belgiumToUsaRating.getAttribute(), "0.58", null, null, null, new Attribute[]{this.voiceRatesIntoRatingZoneRef.getAttribute()});
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }

    public static class RefThisChildRefTargetParamIsUninitialized
    extends ChildRefParamIsUninitialized {
        public final Parameter currentCaseIntoBelgium;
        public final Parameter parentRef;

        public RefThisChildRefTargetParamIsUninitialized(CreationFacade create) {
            super(create);
            this.currentCaseIntoBelgium = create.refParam(this.currentCase, this.belgium);
            this.parentRef = create.textParam(this.currentCase, "ParentRef", "#REF_THIS(Country.ChildRef)");
        }
    }

    public static class RefDslChildRefTargetParamIsUninitialized
    extends ChildRefParamIsUninitialized {
        public final Parameter parentRef;

        public RefDslChildRefTargetParamIsUninitialized(CreationFacade create) {
            super(create);
            this.parentRef = create.textParam(this.currentCase, "ParentRef", "#REF_DSL(Country.Belgium.ChildRef)");
        }
    }

    public static class RefDslChildRefTargetParamHasBrackets
    implements Supplier<VisibilityArea> {
        public final VisibilityArea va;
        public final DataSetList country;
        public final DataSet belgium;
        public final DataSetList cases;
        public final DataSet currentCase;
        public final Attribute capital;
        public final Parameter brussels;
        public final Parameter childRef;
        public final Parameter parentRef;

        public RefDslChildRefTargetParamHasBrackets(CreationFacade create) {
            this.va = create.va("ATPII-3813");
            this.country = create.dsl(this.va, "Country()");
            this.belgium = create.ds(this.country, "Belgium(())");
            this.cases = create.dsl(this.va, "Cases");
            this.currentCase = create.ds(this.cases, "CurrentCase");
            this.capital = create.textAttr(this.country, "Capital()");
            this.brussels = create.textParam(this.belgium, this.capital, "Brussels");
            this.childRef = create.textParam(this.belgium, "ChildRef(brackets)", "#REF_THIS(Capital())");
            create.textParam(this.currentCase, "Capital()", "test");
            this.parentRef = create.textParam(this.currentCase, "ParentRef", "#REF_DSL(Country().Belgium(()).ChildRef(brackets))");
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }

    protected static class ChildRefParamIsInitialized
    extends AbstractCase {
        public final Attribute capital;
        public final Parameter brussels;
        public final Parameter childRef;

        public ChildRefParamIsInitialized(CreationFacade create) {
            super(create);
            this.capital = create.textAttr(this.country, "Capital");
            this.brussels = create.textParam(this.belgium, this.capital, "Brussels");
            this.childRef = create.textParam(this.belgium, "ChildRef", "#REF_THIS(Capital)");
        }
    }

    protected static class ChildRefParamIsUninitialized
    extends AbstractCase {
        public final Attribute capital;
        public final Parameter childRef;

        public ChildRefParamIsUninitialized(CreationFacade create) {
            super(create);
            this.capital = create.textAttr(this.country, "Capital");
            create.textParam(this.currentCase, "Capital", "test");
            this.childRef = create.textParam(this.belgium, "ChildRef", "#REF_THIS(Capital)");
        }
    }

    public static class RefDslChildRefTargetAttrIsUnreachable
    extends ChildRefAttrIsUnreachable {
        public final Parameter parentRef;

        public RefDslChildRefTargetAttrIsUnreachable(CreationFacade create) {
            super(create);
            this.parentRef = create.textParam(this.currentCase, "ParentRef", "#REF_DSL(Country.Belgium.ChildRef)");
        }
    }

    public static class RefThisChildRefTargetAttrIsUnreachable
    extends ChildRefAttrIsUnreachable {
        public final Parameter currentCaseIntoBelgium;
        public final Parameter parentRef;

        public RefThisChildRefTargetAttrIsUnreachable(CreationFacade create) {
            super(create);
            this.currentCaseIntoBelgium = create.refParam(this.currentCase, this.belgium);
            this.parentRef = create.textParam(this.currentCase, "ParentRef", "#REF_THIS(Country.ChildRef)");
        }
    }

    protected static class ChildRefAttrIsUnreachable
    extends AbstractCase {
        public final Attribute capital;
        public final Parameter brussels;
        public final Parameter childRef;

        public ChildRefAttrIsUnreachable(CreationFacade create) {
            super(create);
            this.capital = create.textAttr(this.cases, "Capital");
            this.brussels = create.textParam(this.currentCase, this.capital, "Brussels");
            this.childRef = create.textParam(this.belgium, "ChildRef", "#REF_THIS(Capital)");
        }
    }

    public static class VoiceCaseRefToRefWithOverlap
    implements Supplier<VisibilityArea> {
        public final VisibilityArea va;
        public final DataSetList account;
        public final DataSet b2bAcc;
        public final Parameter b2bAccType;
        public final DataSetList country;
        public final DataSet belgium;
        public final DataSet egypt;
        public final Parameter belgiumZone;
        public final Parameter egyptZone;
        public final Parameter belgiumInternationalZone;
        public final Parameter egyptInternationalZone;
        public final DataSetList internationalVoiceRates;
        public final DataSet proContactRates;
        public final Parameter voiceRatesIntoRatingZoneRef;
        public final Parameter belgiumToWorld2RatingOverlap;
        public final DataSetList subscription;
        public final DataSet proContact;
        public final Parameter tariffName;
        public final DataSetList smsCases;
        public final DataSet belToEgypt;
        public final Parameter usageType;
        public final Parameter belToEgyptIntoSubscriptionRef;
        public final Parameter belToEgyptIntoAccountRef;
        public final Parameter belToEgyptIntoOrigCountryRef;
        public final Parameter belToEgyptIntoDestCountryRef;
        public final Parameter targetParameter;
        public final DataSetList roamingZones;
        public final DataSet belgiumRoamingZone;
        public final Attribute magrebRoamingZone;
        public final DataSetList internationalRatingZones;
        public final DataSet belgiumRatingZone;
        public final Attribute belgiumToWorld2Rating;
        public final DataSetList roamingSmsRates;
        public final DataSet b2bRates;
        public final Parameter b2bRatesIntoBelgiumRoamingZoneRef;
        public final Parameter b2bBelgiumToMagrebRate;

        public VoiceCaseRefToRefWithOverlap(CreationFacade create) {
            this.va = create.va("ATPII-3231");
            this.account = create.dsl(this.va, "Account");
            this.b2bAcc = create.ds(this.account, "B2B Account");
            this.b2bAccType = create.textParam(this.b2bAcc, "AccountType", "B2B");
            this.country = create.dsl(this.va, "Country");
            this.belgium = create.ds(this.country, "Belgium - Belgium");
            this.egypt = create.ds(this.country, "Egypt - Magreb");
            this.belgiumZone = create.textParam(this.belgium, "Zone", "Belgium");
            this.egyptZone = create.textParam(this.egypt, this.belgiumZone.getAttribute(), "Magreb");
            this.belgiumInternationalZone = create.textParam(this.belgium, "IntenationalZone", "Belgium");
            this.egyptInternationalZone = create.textParam(this.egypt, this.belgiumInternationalZone.getAttribute(), "World 2");
            this.subscription = create.dsl(this.va, "Subscription");
            this.proContact = create.ds(this.subscription, "Pro Contact");
            this.tariffName = create.textParam(this.proContact, "TariffName", "Pro Contact");
            this.smsCases = create.dsl(this.va, "SMS cases");
            this.belToEgypt = create.ds(this.smsCases, "TLNT-SOHO-CONTACT-SMS-007 - SMS MO to Magreb number");
            this.usageType = create.textParam(this.belToEgypt, "UsageType", "SMS");
            this.belToEgyptIntoSubscriptionRef = create.refParam(this.belToEgypt, "Subscription", this.proContact);
            this.belToEgyptIntoAccountRef = create.refParam(this.belToEgypt, "Account", this.b2bAcc);
            this.belToEgyptIntoOrigCountryRef = create.refParam(this.belToEgypt, "OriginCountry", this.belgium);
            this.belToEgyptIntoDestCountryRef = create.refParam(this.belToEgypt, "DestinationCountry", this.egypt);
            this.roamingZones = create.dsl(this.va, "Roaming Zones");
            this.belgiumRoamingZone = create.ds(this.roamingZones, "Belgium");
            this.magrebRoamingZone = create.textAttr(this.roamingZones, "Magreb");
            this.internationalRatingZones = create.dsl(this.va, "International Rating Zones");
            this.belgiumRatingZone = create.ds(this.internationalRatingZones, "Belgium");
            this.belgiumToWorld2Rating = create.textAttr(this.internationalRatingZones, "World 2");
            this.internationalVoiceRates = create.dsl(this.va, "International Voice Rates");
            this.proContactRates = create.ds(this.internationalVoiceRates, "Pro Contact");
            this.voiceRatesIntoRatingZoneRef = create.refParam(this.proContactRates, "SMS", this.belgiumRatingZone);
            this.belgiumToWorld2RatingOverlap = create.overrideParam(this.proContactRates, this.belgiumToWorld2Rating, "0.33", null, null, null, new Attribute[]{this.voiceRatesIntoRatingZoneRef.getAttribute()});
            this.roamingSmsRates = create.dsl(this.va, "Roaming SMS Rates");
            this.b2bRates = create.ds(this.roamingSmsRates, "B2B");
            this.b2bRatesIntoBelgiumRoamingZoneRef = create.refParam(this.b2bRates, "Belgium", this.belgiumRoamingZone);
            String vlookupMacro = String.format("#REF_DSL(%s.#REF_THIS(%s.%s).#REF_THIS(%s).#REF_THIS(%s.%s))", this.internationalVoiceRates.getName(), this.belToEgyptIntoSubscriptionRef.getAttribute().getName(), this.tariffName.getAttribute().getName(), this.usageType.getAttribute().getName(), this.belToEgyptIntoDestCountryRef.getAttribute().getName(), this.egyptInternationalZone.getAttribute().getName());
            this.b2bBelgiumToMagrebRate = create.overrideParam(this.b2bRates, this.magrebRoamingZone, vlookupMacro, null, null, null, new Attribute[]{this.b2bRatesIntoBelgiumRoamingZoneRef.getAttribute()});
            String vlookupMacro2 = String.format("#REF_DSL(%s.#REF_THIS(%s.%s).#REF_THIS(%s.%s).#REF_THIS(%s.%s))", this.roamingSmsRates.getName(), this.belToEgyptIntoAccountRef.getAttribute().getName(), this.b2bAccType.getAttribute().getName(), this.belToEgyptIntoOrigCountryRef.getAttribute().getName(), this.belgiumZone.getAttribute().getName(), this.belToEgyptIntoDestCountryRef.getAttribute().getName(), this.egyptZone.getAttribute().getName());
            this.targetParameter = create.textParam(this.belToEgypt, "Target", vlookupMacro2);
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }

    protected static class AbstractCase
    implements Supplier<VisibilityArea> {
        public final VisibilityArea va;
        public final DataSetList country;
        public final DataSet belgium;
        public final DataSetList cases;
        public final DataSet currentCase;

        public AbstractCase(CreationFacade create) {
            this.va = create.va("ATPII-3231");
            this.country = create.dsl(this.va, "Country");
            this.belgium = create.ds(this.country, "Belgium");
            this.cases = create.dsl(this.va, "Cases");
            this.currentCase = create.ds(this.cases, "CurrentCase");
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }
}

