/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.MockJaversCommitEntityServiceConfiguration;
import org.qubership.atp.dataset.config.TestMacrosConfiguration;
import org.qubership.atp.dataset.macros.exception.EvalException;
import org.qubership.atp.dataset.macros.impl.ReferenceMacrosTestData;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.EvaluationService;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@Isolated
@ContextConfiguration(classes={TestMacrosConfiguration.class, MockJaversCommitEntityServiceConfiguration.class})
public class ReferenceThisDSMacrosTest
extends AbstractTest {
    @Autowired
    private EvaluationService evaluationService;

    @Test
    public void wrapToAlias_ReplaceNamesWithIdAndAlias_TypesObtainedByAliasEqualToExpectedTypes() {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        String alias = this.wrapperService.wrapToAlias("#REF_THIS(DS_ExternalDS.ExternalAttr)", d.va, d.dsl);
        this.assertAliasPathEquals(alias, d.externalDsRef.getAttribute().getId(), d.externalParam.getAttribute().getId());
    }

    @Test
    public void wrapToAlias_ReplaceNamesWithIdAndAliasForDslAttr_TypesObtainedByAliasEqualToExpectedTypes() {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        String alias = this.wrapperService.wrapToAlias("#REF_THIS(DS_ExternalDS)", d.va, d.dsl);
        this.assertAliasPathEquals(alias, d.externalDsRef.getAttribute().getId());
    }

    private void assertAliasPathEquals(String wrappedMacros, UUID ... expected) {
        String actualAliasPath = wrappedMacros.substring(wrappedMacros.indexOf("(") + 1, wrappedMacros.length() - 1);
        List ar = StreamSupport.stream(Splitter.on((char)'.').split((CharSequence)actualAliasPath).spliterator(), false).map(UUID::fromString).collect(Collectors.toList());
        List<UUID> er = Arrays.asList(expected);
        MatcherAssert.assertThat(ar, (Matcher)Matchers.hasSize((int)er.size()));
        Iterator arIter = ar.iterator();
        for (UUID erItemId : er) {
            UUID arItemId = (UUID)arIter.next();
            Assertions.assertEquals((Object)erItemId, (Object)arItemId);
        }
    }

    @Test
    public void unWrapAlias_UnWrapToAliasAndCompareWithExpectedNames_ReturnStringEqualToExpected() {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        String expected = "dasdasd #REF_THIS(DS_ExternalDS.ExternalAttr)";
        String wrapped = this.wrapperService.wrapToAlias(expected, d.va, d.dsl);
        String unwrapped = this.wrapperService.unWrapAlias(wrapped);
        Assertions.assertEquals((Object)expected, (Object)unwrapped);
    }

    @Test
    public void evaluate_EvaluateReferenceThis_ReturnValueOfAttributeEqualToExpectedValue() throws EvalException {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            String alias = this.wrapperService.wrapToAlias("#REF_THIS(DS_ExternalDS.ExternalAttr)", d.va, d.dsl);
            String evaluate = evaluator.evaluateText(d.ds, alias);
            Assertions.assertEquals((Object)d.expectedValue, (Object)evaluate);
        }
    }

    @Test
    public void evaluate_RefToTargetParamWithoutGroup_Resolved() throws EvalException {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            String alias = this.wrapperService.wrapToAlias("#REF_THIS(Attr)", d.va, d.dsl);
            String evaluate = evaluator.evaluateText(d.ds, alias);
            Assertions.assertEquals((Object)d.expectedValue, (Object)evaluate);
        }
    }

    @Test
    public void evaluate_RefToDSLAttr_EqualsDsName() throws EvalException {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            String alias = this.wrapperService.wrapToAlias("#REF_THIS(DS_ExternalDS)", d.va, d.dsl);
            String evaluate = evaluator.evaluateText(d.ds, alias);
            Assertions.assertEquals((Object)"ExternalDS", (Object)evaluate);
        }
    }
}

