/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.DuplicateKeyException;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class VisibilityAreaServiceTest
extends AbstractTest {
    @Test
    public void testCascadeDeleteVisibilityArea() throws DuplicateKeyException {
        VisibilityArea area = this.visibilityAreaService.create("V");
        DataSetList dsl = this.dataSetListService.create(area.getId(), "DSL", null);
        DataSet ds = this.dataSetService.create(dsl.getId(), "DS");
        Attribute attribute = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "A", AttributeType.TEXT, null, null);
        Parameter parameter = this.parameterService.create(ds.getId(), attribute.getId(), "Text", null, null);
        this.visibilityAreaService.delete(area.getId());
        Assertions.assertFalse((boolean)this.visibilityAreaService.getAll().contains(area));
        Assertions.assertNull((Object)this.dataSetListService.get(dsl.getId()));
        Assertions.assertNull((Object)this.dataSetService.get(ds.getId()));
        Assertions.assertNull((Object)this.attributeService.get(attribute.getId()));
        Assertions.assertNull((Object)this.parameterService.get(parameter.getId()));
    }
}

