/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.dataset.controllers.api;

import java.util.UUID;
import org.qubership.atp.dataset.controllers.api.dto.visibilityareas.VisibilityAreaFlatModelDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-03T07:08:34.378519600Z[Etc/UTC]")
@Validated
@Tag(name = "VisibilityAreaController", description = "Visibility Area Controller")
public interface VisibilityAreaControllerApi {

    /**
     * POST /va/{visibilityAreaId}/copyTo : Copy DSL with name provided.
     *
     * @param visibilityAreaId visibilityAreaId (required)
     * @param body  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copyToVisibilityArea",
        summary = "Copy DSL with name provided.",
        tags = { "visibility-area-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/va/{visibilityAreaId}/copyTo",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> copyToVisibilityArea(
        @Parameter(name = "visibilityAreaId", description = "visibilityAreaId", required = true) @PathVariable("visibilityAreaId") UUID visibilityAreaId,
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) UUID body
    );


    /**
     * PUT /va : Creates new visibility area with provided name and order.
     *
     * @param name name (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "Creates new visibility area with provided name and order.",
        tags = { "visibility-area-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/va",
        produces = { "application/json" }
    )
    ResponseEntity<UUID> create(
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name
    );


    /**
     * DELETE /va/{visibilityAreaId} : Deletes selected VA.
     *
     * @param visibilityAreaId visibilityAreaId (required)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "delete",
        summary = "Deletes selected VA.",
        tags = { "visibility-area-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/va/{visibilityAreaId}"
    )
    ResponseEntity<Void> delete(
        @Parameter(name = "visibilityAreaId", description = "visibilityAreaId", required = true) @PathVariable("visibilityAreaId") UUID visibilityAreaId
    );


    /**
     * GET /va : Returns all visibility areas.
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getVisibilityAreas",
        summary = "Returns all visibility areas.",
        tags = { "visibility-area-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = VisibilityAreaFlatModelDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/va",
        produces = { "application/json" }
    )
    ResponseEntity<List<VisibilityAreaFlatModelDto>> getVisibilityAreas(
        
    );


    /**
     * GET /va/sorted : Returns all visibility areas sorted by name.
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getVisibilityAreasSorted",
        summary = "Returns all visibility areas sorted by name.",
        tags = { "visibility-area-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = VisibilityAreaFlatModelDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/va/sorted",
        produces = { "application/json" }
    )
    ResponseEntity<List<VisibilityAreaFlatModelDto>> getVisibilityAreasSorted(
        
    );


    /**
     * POST /va/{visibilityAreaId} : Renames selected VA.
     *
     * @param visibilityAreaId visibilityAreaId (required)
     * @param name name (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "rename",
        summary = "Renames selected VA.",
        tags = { "visibility-area-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Boolean.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/va/{visibilityAreaId}",
        produces = { "application/json" }
    )
    ResponseEntity<Boolean> rename(
        @Parameter(name = "visibilityAreaId", description = "visibilityAreaId", required = true) @PathVariable("visibilityAreaId") UUID visibilityAreaId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name
    );

}
