package org.qubership.atp.dataset.controllers.api.dto.datasetlists;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CopyDataSetListsResponseDto
 */

@JsonTypeName("CopyDataSetListsResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-03T07:08:33.546062377Z[Etc/UTC]")
public class CopyDataSetListsResponseDto {

  @JsonProperty("copyId")
  private UUID copyId;

  @JsonProperty("datasets")
  @Valid
  private Map<String, UUID> datasets = null;

  @JsonProperty("originalId")
  private UUID originalId;

  public CopyDataSetListsResponseDto copyId(UUID copyId) {
    this.copyId = copyId;
    return this;
  }

  /**
   * Get copyId
   * @return copyId
  */
  @Valid 
  @Schema(name = "copyId", required = false)
  public UUID getCopyId() {
    return copyId;
  }

  public void setCopyId(UUID copyId) {
    this.copyId = copyId;
  }

  public CopyDataSetListsResponseDto datasets(Map<String, UUID> datasets) {
    this.datasets = datasets;
    return this;
  }

  public CopyDataSetListsResponseDto putDatasetsItem(String key, UUID datasetsItem) {
    if (this.datasets == null) {
      this.datasets = new HashMap<>();
    }
    this.datasets.put(key, datasetsItem);
    return this;
  }

  /**
   * Get datasets
   * @return datasets
  */
  @Valid 
  @Schema(name = "datasets", required = false)
  public Map<String, UUID> getDatasets() {
    return datasets;
  }

  public void setDatasets(Map<String, UUID> datasets) {
    this.datasets = datasets;
  }

  public CopyDataSetListsResponseDto originalId(UUID originalId) {
    this.originalId = originalId;
    return this;
  }

  /**
   * Get originalId
   * @return originalId
  */
  @Valid 
  @Schema(name = "originalId", required = false)
  public UUID getOriginalId() {
    return originalId;
  }

  public void setOriginalId(UUID originalId) {
    this.originalId = originalId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CopyDataSetListsResponseDto copyDataSetListsResponse = (CopyDataSetListsResponseDto) o;
    return Objects.equals(this.copyId, copyDataSetListsResponse.copyId) &&
        Objects.equals(this.datasets, copyDataSetListsResponse.datasets) &&
        Objects.equals(this.originalId, copyDataSetListsResponse.originalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(copyId, datasets, originalId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CopyDataSetListsResponseDto {\n");
    sb.append("    copyId: ").append(toIndentedString(copyId)).append("\n");
    sb.append("    datasets: ").append(toIndentedString(datasets)).append("\n");
    sb.append("    originalId: ").append(toIndentedString(originalId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

