package org.qubership.atp.dataset.controllers.api.dto.datasetlists;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.controllers.api.dto.datasetlists.DataSetListDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * VisibilityAreaDto
 */

@JsonTypeName("VisibilityArea")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-03T07:08:33.546062377Z[Etc/UTC]")
public class VisibilityAreaDto {

  @JsonProperty("dataSetLists")
  @Valid
  private List<DataSetListDto> dataSetLists = null;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("name")
  private String name;

  public VisibilityAreaDto dataSetLists(List<DataSetListDto> dataSetLists) {
    this.dataSetLists = dataSetLists;
    return this;
  }

  public VisibilityAreaDto addDataSetListsItem(DataSetListDto dataSetListsItem) {
    if (this.dataSetLists == null) {
      this.dataSetLists = new ArrayList<>();
    }
    this.dataSetLists.add(dataSetListsItem);
    return this;
  }

  /**
   * Get dataSetLists
   * @return dataSetLists
  */
  @Valid 
  @Schema(name = "dataSetLists", required = false)
  public List<DataSetListDto> getDataSetLists() {
    return dataSetLists;
  }

  public void setDataSetLists(List<DataSetListDto> dataSetLists) {
    this.dataSetLists = dataSetLists;
  }

  public VisibilityAreaDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @NotNull @Valid 
  @Schema(name = "id", required = true)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public VisibilityAreaDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", required = true)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VisibilityAreaDto visibilityArea = (VisibilityAreaDto) o;
    return Objects.equals(this.dataSetLists, visibilityArea.dataSetLists) &&
        Objects.equals(this.id, visibilityArea.id) &&
        Objects.equals(this.name, visibilityArea.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataSetLists, id, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VisibilityAreaDto {\n");
    sb.append("    dataSetLists: ").append(toIndentedString(dataSetLists)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

