package org.qubership.atp.dataset.service.rest.dto.versioning;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.math.BigDecimal;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * HistoryItemDto
 */

@JsonTypeName("HistoryItem")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-03T07:08:32.302897680Z[Etc/UTC]")
public class HistoryItemDto implements java.io.Serializable {

  @JsonProperty("version")
  private Integer version;

  @JsonProperty("modifiedWhen")
  private String modifiedWhen;

  @JsonProperty("modifiedBy")
  private String modifiedBy;

  @JsonProperty("attribute")
  private String attribute;

  @JsonProperty("dataSet")
  private String dataSet;

  @JsonProperty("changeSummary")
  private String changeSummary;

  @JsonProperty("oldValue")
  private String oldValue;

  @JsonProperty("newValue")
  private String newValue;

  @JsonProperty("commitId")
  private BigDecimal commitId;

  public HistoryItemDto version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * Version number of current changes
   * minimum: 1
   * @return version
  */
  @Min(1) 
  @Schema(name = "version", description = "Version number of current changes", required = false)
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public HistoryItemDto modifiedWhen(String modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  
  @Schema(name = "modifiedWhen", example = "2020-04-15T12:34:56.789Z", required = false)
  public String getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(String modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public HistoryItemDto modifiedBy(String modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  
  @Schema(name = "modifiedBy", example = "Administrator", required = false)
  public String getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(String modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public HistoryItemDto attribute(String attribute) {
    this.attribute = attribute;
    return this;
  }

  /**
   * Get attribute
   * @return attribute
  */
  
  @Schema(name = "attribute", example = "Account", required = false)
  public String getAttribute() {
    return attribute;
  }

  public void setAttribute(String attribute) {
    this.attribute = attribute;
  }

  public HistoryItemDto dataSet(String dataSet) {
    this.dataSet = dataSet;
    return this;
  }

  /**
   * Get dataSet
   * @return dataSet
  */
  
  @Schema(name = "dataSet", example = "TLNT-BASE-BVC-002", required = false)
  public String getDataSet() {
    return dataSet;
  }

  public void setDataSet(String dataSet) {
    this.dataSet = dataSet;
  }

  public HistoryItemDto changeSummary(String changeSummary) {
    this.changeSummary = changeSummary;
    return this;
  }

  /**
   * Get changeSummary
   * @return changeSummary
  */
  
  @Schema(name = "changeSummary", example = "Changed", required = false)
  public String getChangeSummary() {
    return changeSummary;
  }

  public void setChangeSummary(String changeSummary) {
    this.changeSummary = changeSummary;
  }

  public HistoryItemDto oldValue(String oldValue) {
    this.oldValue = oldValue;
    return this;
  }

  /**
   * Get oldValue
   * @return oldValue
  */
  
  @Schema(name = "oldValue", example = "OldValue23", required = false)
  public String getOldValue() {
    return oldValue;
  }

  public void setOldValue(String oldValue) {
    this.oldValue = oldValue;
  }

  public HistoryItemDto newValue(String newValue) {
    this.newValue = newValue;
    return this;
  }

  /**
   * Get newValue
   * @return newValue
  */
  
  @Schema(name = "newValue", example = "NewValue42", required = false)
  public String getNewValue() {
    return newValue;
  }

  public void setNewValue(String newValue) {
    this.newValue = newValue;
  }

  public HistoryItemDto commitId(BigDecimal commitId) {
    this.commitId = commitId;
    return this;
  }

  /**
   * Get commitId
   * @return commitId
  */
  @Valid 
  @Schema(name = "commitId", required = false)
  public BigDecimal getCommitId() {
    return commitId;
  }

  public void setCommitId(BigDecimal commitId) {
    this.commitId = commitId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoryItemDto historyItem = (HistoryItemDto) o;
    return Objects.equals(this.version, historyItem.version) &&
        Objects.equals(this.modifiedWhen, historyItem.modifiedWhen) &&
        Objects.equals(this.modifiedBy, historyItem.modifiedBy) &&
        Objects.equals(this.attribute, historyItem.attribute) &&
        Objects.equals(this.dataSet, historyItem.dataSet) &&
        Objects.equals(this.changeSummary, historyItem.changeSummary) &&
        Objects.equals(this.oldValue, historyItem.oldValue) &&
        Objects.equals(this.newValue, historyItem.newValue) &&
        Objects.equals(this.commitId, historyItem.commitId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, modifiedWhen, modifiedBy, attribute, dataSet, changeSummary, oldValue, newValue, commitId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoryItemDto {\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    attribute: ").append(toIndentedString(attribute)).append("\n");
    sb.append("    dataSet: ").append(toIndentedString(dataSet)).append("\n");
    sb.append("    changeSummary: ").append(toIndentedString(changeSummary)).append("\n");
    sb.append("    oldValue: ").append(toIndentedString(oldValue)).append("\n");
    sb.append("    newValue: ").append(toIndentedString(newValue)).append("\n");
    sb.append("    commitId: ").append(toIndentedString(commitId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

