/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.dataset.service.rest.server;

import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemResponseDto;
import java.util.UUID;
import org.qubership.atp.dataset.service.rest.dto.versioning.UiManDataSetListJDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-03T07:08:32.302897680Z[Etc/UTC]")
@Validated
@Tag(name = "HistoryController", description = "Model History API")
public interface HistoryControllerApi {

    /**
     * GET /api/history/{projectId}/datasetlist/{id} : Finds all changes history for defined data set list
     *
     * @param projectId  (required)
     * @param id  (required)
     * @param offset  (optional, default to 0)
     * @param limit  (optional, default to 10)
     * @return OK (status code 200)
     *         or Entity Id not found (status code 404)
     */
    @Operation(
        operationId = "getAllHistory",
        summary = "Finds all changes history for defined data set list",
        tags = { "history-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = HistoryItemResponseDto.class))
            }),
            @ApiResponse(responseCode = "404", description = "Entity Id not found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/history/{projectId}/datasetlist/{id}",
        produces = { "application/json" }
    )
    ResponseEntity<HistoryItemResponseDto> getAllHistory(
        @Parameter(name = "projectId", description = "", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "offset", description = "") @Valid @RequestParam(value = "offset", required = false, defaultValue = "0") Integer offset,
        @Parameter(name = "limit", description = "") @Valid @RequestParam(value = "limit", required = false, defaultValue = "10") Integer limit
    );


    /**
     * GET /api/history/{projectId}/datasetlist/revisionDetails/{entityId}/{revision} : Find model of Dataset List by revision
     *
     * @param projectId  (required)
     * @param entityId  (required)
     * @param revision  (required)
     * @return OK (status code 200)
     *         or Entity Id not found (status code 404)
     */
    @Operation(
        operationId = "getRevisionDetails",
        summary = "Find model of Dataset List by revision",
        tags = { "history-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UiManDataSetListJDto.class))
            }),
            @ApiResponse(responseCode = "404", description = "Entity Id not found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/history/{projectId}/datasetlist/revisionDetails/{entityId}/{revision}",
        produces = { "application/json" }
    )
    ResponseEntity<UiManDataSetListJDto> getRevisionDetails(
        @Parameter(name = "projectId", description = "", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "entityId", description = "", required = true) @PathVariable("entityId") UUID entityId,
        @Parameter(name = "revision", description = "", required = true) @PathVariable("revision") Integer revision
    );


    /**
     * POST /api/history/restore/{projectId}/datasetlist/{id}/revision/{revisionId} : Restore the state of the provided entity to defined revision
     *
     * @param projectId  (required)
     * @param id  (required)
     * @param revisionId  (required)
     * @return Revision was restored successfully (status code 200)
     *         or Forbidden (status code 403)
     *         or Entity Id not found (status code 404)
     *         or Revision was not restored (status code 500)
     */
    @Operation(
        operationId = "restoreToRevision",
        summary = "Restore the state of the provided entity to defined revision",
        tags = { "history-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Revision was restored successfully"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Entity Id not found"),
            @ApiResponse(responseCode = "500", description = "Revision was not restored")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/history/restore/{projectId}/datasetlist/{id}/revision/{revisionId}"
    )
    ResponseEntity<Void> restoreToRevision(
        @Parameter(name = "projectId", description = "", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "revisionId", description = "", required = true) @PathVariable("revisionId") Integer revisionId
    );

}
