/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.script.ScriptEngineManager;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.qubership.atp.dataset.antlr4.TextParameterParser;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.impl.macro.CachedDslMacroResultContainer;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.MacroContextService;
import org.qubership.atp.dataset.service.jpa.model.PathStep;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.TestUtils;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.calculator.ScriptMacrosCalculator;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
public abstract class AbstractMacroTest {
    private static final UUID DSL_ID = UUID.randomUUID();
    protected static final String MACRO_RESULT = "MY TEXT";
    protected TextParameterParser parser;

    @BeforeEach
    public void setUp() {
        MacroContext macroContext = new MacroContext();
        macroContext.setMacroContextService((MacroContextService)new TestMacroContextService());
        macroContext.setDataSetListContext(new DataSetListContext(DSL_ID));
        macroContext.setMacrosCalculator((MacrosCalculator)new ScriptMacrosCalculator(new ScriptEngineManager()));
        macroContext.setMacros(Arrays.asList(TestUtils.getUuidMacros(), TestUtils.getCharsUpperCaseMacros(), TestUtils.getCharsMacros(), TestUtils.getInnMacros(), TestUtils.getRandMacros()));
        ParameterPositionContext parameterPositionContext = new ParameterPositionContext(Collections.emptyList(), 0, null, Long.valueOf(0L), DSL_ID);
        this.parser = new TextParameterParser(macroContext, parameterPositionContext);
    }

    private static class TestMacroContextService
    implements MacroContextService {
        private TestMacroContextService() {
        }

        public String getTextParameterByListDataSetAndPath(UUID visibilityAreaId, PathStep dataSetList, PathStep dataSet, List<PathStep> referenceAttributePath, PathStep parameterAttribute) {
            return AbstractMacroTest.MACRO_RESULT;
        }

        public String getTextParameterByExternalListDataSetAndPath(UUID visibilityAreaId, PathStep dataSetList, PathStep dataSet, List<PathStep> referenceAttributePath, PathStep parameterAttribute) {
            return AbstractMacroTest.MACRO_RESULT;
        }

        public String getTextParameterFromCachedContextByNamesPath(UUID visibilityAreaId, PathStep topLevelDataSetList, UUID dataSetId, int dataSetColumn, List<UUID> macroPosition, List<PathStep> pathSteps, PathStep attribute) {
            return AbstractMacroTest.MACRO_RESULT;
        }

        public String getDataSetListName(UUID dataSetListId) {
            return AbstractMacroTest.MACRO_RESULT;
        }

        public String getDataSetName(UUID dataSetListId) {
            return AbstractMacroTest.MACRO_RESULT;
        }

        public UUID getDataSetUuid(String dataSetName, UUID dataSetListId) {
            return null;
        }

        public DataSetList getDataSetList(UUID visibilityAreaId, PathStep dataSetListPathStep) {
            DataSetListEntity entity = new DataSetListEntity();
            entity.setId(DSL_ID);
            return new DataSetList(entity);
        }

        public String getAttributeName(UUID dataSetListId) {
            return AbstractMacroTest.MACRO_RESULT;
        }

        public Map<ParameterPositionContext, String> getCachedEvaluatedValues(UUID dataSetListId) {
            return null;
        }

        public CachedDslMacroResultContainer getDslMacroCache() {
            return new CachedDslMacroResultContainer();
        }

        public void dropLocalThreadCache() {
        }
    }
}

