/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.ws;

import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.FieldReader;
import org.qubership.atp.dataset.service.ws.event.Event;
import org.qubership.atp.dataset.service.ws.event.EventHandler;
import org.springframework.web.socket.WebSocketSession;

@Isolated
public class WebSocketHandlerTest {
    private EventHandler handler;
    private WebSocketSession webSocket;
    private String sessionId = "sessionId";
    private String dslId = "dslId";
    private Event event;

    @BeforeEach
    public void setUp() {
        this.handler = new EventHandler();
        this.webSocket = (WebSocketSession)Mockito.mock(WebSocketSession.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteHost()).thenReturn((Object)"wsmsa-026");
        Mockito.when((Object)this.webSocket.getLocalAddress()).thenReturn((Object)new InetSocketAddress("testHost", 8080));
        this.event = new Event();
        this.event.setDataSetListId(this.dslId);
        this.event.setSessionId(this.sessionId);
        this.handler.add(this.event, this.webSocket);
    }

    @Test
    public void testEventIsPresentedInMapAfterAdding() {
        Map<String, Map<String, WebSocketSession>> map = this.getSocketMap();
        Assertions.assertSame((Object)this.webSocket, (Object)map.get(this.dslId).get(this.sessionId));
    }

    private Map<String, Map<String, WebSocketSession>> getSocketMap() {
        try {
            Class<?> clazz = this.handler.getClass();
            Field socketMap = clazz.getDeclaredField("SOCKET_MAP");
            FieldReader fieldReader = new FieldReader((Object)this.handler, socketMap);
            return (Map)fieldReader.read();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Error reading field SOCKET_MAP", e);
        }
    }

    @Test
    public void testEventsIsAccessibleByDslId() {
        Event event = new Event();
        event.setSessionId("1");
        event.setDataSetListId("1");
        WebSocketSession webSocketSession = (WebSocketSession)Mockito.mock(WebSocketSession.class);
        Mockito.when((Object)webSocketSession.getLocalAddress()).thenReturn((Object)new InetSocketAddress("localhost", 8080));
        this.handler.add(event, webSocketSession);
        Collection webSockets = this.handler.getWebSockets(this.event);
        Assertions.assertEquals((int)1, (int)webSockets.size());
        Assertions.assertSame((Object)this.webSocket, webSockets.iterator().next());
    }

    @Test
    public void testSocketIsRemovedFromHandlerBySocketInstance() {
        this.handler.remove(this.webSocket);
        Assertions.assertEquals((int)0, (int)this.getSocketMap().get(this.dslId).size());
    }

    @Test
    public void testSocketIsRemovedFromHandlerByEvent() {
        this.handler.remove(this.event);
        Assertions.assertEquals((int)0, (int)this.getSocketMap().get(this.dslId).size());
    }
}

