/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ui.api;

import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.json.JSONException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.utils.MultiplyTestData;
import org.qubership.atp.dataset.ui.api.AbstractApiIntegrationCase;

@Isolated
public class JsonViewITCase
extends AbstractApiIntegrationCase {
    private MultiplyTestData data;

    @BeforeEach
    public void init() {
        this.data = this.createTestDataInstance(MultiplyTestData::new);
    }

    @Test
    public void getDataSetLists_UnderVa_OnlyIdNameLabelsAreProvided() throws JSONException {
        Invocation.Builder request = baseUrl.path("dsl/va").path(this.data.va.getId().toString()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        String ar = (String)request.get(String.class);
        List<DataSetListImpl> actual = this.getResponse(ar);
        MatcherAssert.assertThat((Object)Response.Status.OK.getStatusCode(), (Matcher)Matchers.equalTo((Object)request.get().getStatus()));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)this.data.accounts.getId()))));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)this.data.subscriptions.getId()))));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)this.data.requested.getId()))));
    }

    @Test
    public void getDataSets_UnderDsl_OnlyIdNameLabelsAreProvided() throws JSONException {
        Invocation.Builder request = baseUrl.path("dsl").path(this.data.accounts.getId().toString()).path("ds").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        String ar = (String)request.get(String.class);
        List<DataSetListImpl> actual = this.getResponse(ar);
        MatcherAssert.assertThat((Object)Response.Status.OK.getStatusCode(), (Matcher)Matchers.equalTo((Object)request.get().getStatus()));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)this.data.resCA.getId()))));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)this.data.b2bCA.getId()))));
    }
}

