/*
 * Decompiled with CFR 0.152.
 */
package com.stoyanr.evictor.scheduler;

import com.stoyanr.evictor.EvictionQueue;
import com.stoyanr.evictor.map.EvictibleEntry;
import com.stoyanr.evictor.scheduler.AbstractQueueEvictionScheduler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DelayedTaskEvictionScheduler<K, V>
extends AbstractQueueEvictionScheduler<K, V> {
    public static final int DEFAULT_THREAD_POOL_SIZE = 1;
    private final ScheduledExecutorService ses;
    private volatile ScheduledFuture<?> future = null;
    private volatile long next = 0L;

    public DelayedTaskEvictionScheduler() {
        this(new ScheduledThreadPoolExecutor(1));
    }

    public DelayedTaskEvictionScheduler(ScheduledExecutorService ses) {
        if (ses == null) {
            throw new NullPointerException("ScheduledExecutorService instance cannot be null");
        }
        this.ses = ses;
    }

    public DelayedTaskEvictionScheduler(EvictionQueue<K, V> queue) {
        this(queue, new ScheduledThreadPoolExecutor(1));
    }

    public DelayedTaskEvictionScheduler(EvictionQueue<K, V> queue, ScheduledExecutorService executorService) {
        super(queue);
        if (executorService == null) {
            throw new NullPointerException("ScheduledExecutorService instance cannot be null");
        }
        this.ses = executorService;
    }

    @Override
    public void shutdown() {
        this.ses.shutdownNow();
    }

    @Override
    protected void onScheduleEviction(EvictibleEntry<K, V> e) {
        if (this.getNextEvictionTime() != this.next) {
            this.scheduleTask();
        }
    }

    @Override
    protected void onCancelEviction(EvictibleEntry<K, V> e) {
        if (this.getNextEvictionTime() != this.next) {
            this.scheduleTask();
        }
    }

    @Override
    protected void onEvictEntries() {
        this.schedule();
    }

    private synchronized void scheduleTask() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.schedule();
    }

    private synchronized void schedule() {
        this.next = this.getNextEvictionTime();
        this.future = this.next > 0L ? this.ses.schedule(new AbstractQueueEvictionScheduler.EvictionRunnable(), Math.max(this.next - System.nanoTime(), 0L), TimeUnit.NANOSECONDS) : null;
    }
}

