/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptPredicateList;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.rules.SubstitutionRule;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import java.util.List;
import java.util.stream.Collectors;

public class SortRemoveConstantKeysRule
extends RelOptRule
implements SubstitutionRule {
    public static final SortRemoveConstantKeysRule INSTANCE = new SortRemoveConstantKeysRule();

    private SortRemoveConstantKeysRule() {
        super(SortRemoveConstantKeysRule.operand(Sort.class, SortRemoveConstantKeysRule.any()), RelFactories.LOGICAL_BUILDER, "SortRemoveConstantKeysRule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        Sort sort = (Sort)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(input = sort.getInput());
        if (predicates == null) {
            return;
        }
        RexBuilder rexBuilder = sort.getCluster().getRexBuilder();
        List<RelFieldCollation> collationsList = sort.getCollation().getFieldCollations().stream().filter(fc -> !predicates.constantMap.containsKey(rexBuilder.makeInputRef(input, fc.getFieldIndex()))).collect(Collectors.toList());
        if (collationsList.size() == sort.collation.getFieldCollations().size()) {
            return;
        }
        if (collationsList.isEmpty() && sort.offset == null && sort.fetch == null) {
            call.transformTo(input);
            call.getPlanner().prune(sort);
            return;
        }
        Sort result = sort.copy(sort.getTraitSet(), input, RelCollations.of(collationsList));
        call.transformTo(result);
        call.getPlanner().prune(sort);
    }
}

