/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.migration.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qubership.atp.dataset.db.migration.Utils;
import org.qubership.atp.dataset.db.migration.classloader.ChildClassLoader;
import org.qubership.atp.dataset.db.migration.customchange.constant.JoinerSplitterConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentLastClassloader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(ParentLastClassloader.class);
    private static final String JAR = ".jar";
    private static final Logger LOGGER = LoggerFactory.getLogger(ParentLastClassloader.class);
    private static final String Q_CLASSES_JAR_EXPRESSION = "atp-dataset-q-classes-generation.+\\.jar";
    private final String sourcePath;
    private Map<String, ChildClassLoader> urlClassLoaders = new HashMap<String, ChildClassLoader>();
    private String jdbcType;

    public ParentLastClassloader(URLClassLoader urlClassLoader, String sourcePath, String jdbcType) {
        super(urlClassLoader.getURLs(), (ClassLoader)urlClassLoader);
        this.jdbcType = jdbcType;
        if (Objects.isNull(jdbcType) || jdbcType.isEmpty()) {
            throw new IllegalStateException("Parameter 'jdbc_type' can't be null or empty.Value of jdbc_type depends of suffix in jar name, which contains generated q-classes.atp-dataset-q-classes-generation-pg.jar - there is jdbc_type is 'pg'");
        }
        this.sourcePath = sourcePath;
        try (Stream<Path> walk = Files.walk(Paths.get(sourcePath, new String[0]), new FileVisitOption[0]);){
            walk.filter(path -> !Utils.isJarFile(path)).forEach(path -> {
                try {
                    this.addURL(path.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Unable convert file to url", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Unable to add resource files to classpath", (Throwable)e);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = null;
        try {
            resources = this.findResources(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resources != null && !resources.hasMoreElements()) {
            return this.loadFromSuper(name);
        }
        return resources;
    }

    private Enumeration<URL> loadFromSuper(String name) throws IOException {
        LOGGER.warn("Resource not found in self class loader. Resource: " + name);
        return super.getResources(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return null;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.isClassInsideBasePackOrThirdPartyPacks(className)) {
            return super.loadClass(className, false);
        }
        if (!className.matches("^v\\d+.+")) {
            throw new IllegalArgumentException("Is liquibase started loading new change set?");
        }
        ChildClassLoader urlClassLoader = this.refreshClassLoader(className);
        Class<?> loadedClass = urlClassLoader.loadClass(className);
        if (loadedClass == null) {
            super.loadClass(className);
        }
        return loadedClass;
    }

    private boolean isClassInsideBasePackOrThirdPartyPacks(String className) {
        if (!className.startsWith("org.qubership.atp.dataset.db.migration.customchange.task") && !className.startsWith("liquibase")) {
            return false;
        }
        String packageName = this.getPackageName(className);
        return "org.qubership.atp.dataset.db.migration.customchange.task".equals(packageName) || packageName.startsWith("liquibase");
    }

    private String getPackageName(String className) {
        List splitClassPath = JoinerSplitterConstants.POINT_SPLITTER.splitToList((CharSequence)className);
        splitClassPath = splitClassPath.stream().limit(splitClassPath.size() - 1).collect(Collectors.toList());
        return JoinerSplitterConstants.POINT_JOINER.join(splitClassPath);
    }

    protected ChildClassLoader refreshClassLoader(String className) {
        String jarPath = className.replaceAll("\\.", "/").replaceFirst("\\w+$", "");
        ChildClassLoader urlClassLoader = this.urlClassLoaders.get(jarPath);
        if (urlClassLoader != null) {
            return urlClassLoader;
        }
        try {
            Path dir = Paths.get(this.sourcePath, jarPath);
            List<Path> jarList = Files.list(dir).filter(Utils::isJarFile).collect(Collectors.toList());
            urlClassLoader = this.createNewUrlClassLoader(jarList);
            this.urlClassLoaders.put(jarPath, urlClassLoader);
            return urlClassLoader;
        }
        catch (IOException e) {
            throw new IllegalStateException("Jar file is not found by path:" + jarPath, e);
        }
    }

    private ChildClassLoader createNewUrlClassLoader(List<Path> jarList) {
        LinkedList urls = new LinkedList();
        jarList.forEach(path -> {
            try {
                String name = path.toFile().getName().toLowerCase();
                if (name.matches(Q_CLASSES_JAR_EXPRESSION)) {
                    this.loadGeneratedQClasses(urls, name, (Path)path);
                } else {
                    urls.add(this.getUrl((Path)path));
                }
            }
            catch (IOException e) {
                LOGGER.error("Can't convert path to URL. File path:" + path, (Throwable)e);
            }
        });
        return new ChildClassLoader(urls.toArray(new URL[urls.size()]), this, this.getParent());
    }

    private void loadGeneratedQClasses(List<URL> urls, String name, Path path) throws IOException {
        if (name.endsWith(this.jdbcType + JAR)) {
            urls.add(this.getUrl(path));
        }
    }

    private URL getUrl(Path jarFile) throws IOException {
        return new URL("jar:file:" + jarFile.toString() + "!/");
    }
}

