/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.blocking.retry;

import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.http.HttpMethod;

public class BlockingLoadBalancedRetryPolicy
implements LoadBalancedRetryPolicy {
    private final LoadBalancerProperties properties;
    private int sameServerCount = 0;
    private int nextServerCount = 0;

    public BlockingLoadBalancedRetryPolicy(LoadBalancerProperties properties) {
        this.properties = properties;
    }

    public boolean canRetry(LoadBalancedRetryContext context) {
        HttpMethod method = context.getRequest().getMethod();
        return HttpMethod.GET.equals((Object)method) || this.properties.getRetry().isRetryOnAllOperations();
    }

    public boolean canRetrySameServer(LoadBalancedRetryContext context) {
        return this.sameServerCount < this.properties.getRetry().getMaxRetriesOnSameServiceInstance() && this.canRetry(context);
    }

    public boolean canRetryNextServer(LoadBalancedRetryContext context) {
        return this.nextServerCount <= this.properties.getRetry().getMaxRetriesOnNextServiceInstance() && this.canRetry(context);
    }

    public void close(LoadBalancedRetryContext context) {
    }

    public void registerThrowable(LoadBalancedRetryContext context, Throwable throwable) {
        if (!this.canRetrySameServer(context) && this.canRetry(context)) {
            this.sameServerCount = 0;
            ++this.nextServerCount;
            if (!this.canRetryNextServer(context)) {
                context.setExhaustedOnly();
            } else {
                context.setServiceInstance(null);
            }
        } else {
            ++this.sameServerCount;
        }
    }

    public boolean retryableStatusCode(int statusCode) {
        return this.properties.getRetry().getRetryableStatusCodes().contains(statusCode);
    }
}

