/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.config;

import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import org.qubership.atp.ei.node.clients.ExportImportFeignClient;
import org.qubership.atp.ei.node.config.CustomRunsPolicy;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@ComponentScan(value={"org.qubership.atp.ei.node"})
@EnableFeignClients(clients={ExportImportFeignClient.class})
@Configuration
public class ExportImportNodeConfig {
    @Value(value="${atp.export.threadPool.corePoolSize:0}")
    private Integer corePoolSize;
    @Value(value="${atp.export.threadPool.maxPoolSize:40}")
    private Integer maxPoolSize;
    @Value(value="${atp.export.threadPool.queueCapacity:0}")
    private Integer queueCapacity;
    public static String DEFAULT_WORK_DIR;

    @Value(value="${atp.export.workdir:exportimport/node}")
    public void setDefaultWorkDir(String defaultWorkDir) {
        DEFAULT_WORK_DIR = defaultWorkDir;
    }

    @Bean(value={"atpExportThreadExecutor"})
    public ThreadPoolTaskExecutor atpExportThreadExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("atp-export-");
        executor.setCorePoolSize(this.corePoolSize.intValue());
        executor.setMaxPoolSize(this.maxPoolSize.intValue());
        executor.setQueueCapacity(this.queueCapacity.intValue());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new CustomRunsPolicy());
        executor.initialize();
        return executor;
    }

    @Bean(value={"atpImportThreadExecutor"})
    public ThreadPoolTaskExecutor atpImportThreadExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("atp-import-");
        executor.setCorePoolSize(this.corePoolSize.intValue());
        executor.setMaxPoolSize(this.maxPoolSize.intValue());
        executor.setQueueCapacity(this.queueCapacity.intValue());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new CustomRunsPolicy());
        executor.initialize();
        return executor;
    }

    @Bean
    public ExecutorServiceMetrics executorExportMetrics(@Qualifier(value="atpExportThreadExecutor") ThreadPoolTaskExecutor applicationTaskExecutor) {
        return new ExecutorServiceMetrics((ExecutorService)applicationTaskExecutor.getThreadPoolExecutor(), applicationTaskExecutor.getThreadNamePrefix(), "export_threads", (Iterable)Tags.empty());
    }

    @Bean
    public ExecutorServiceMetrics executorImportMetrics(@Qualifier(value="atpImportThreadExecutor") ThreadPoolTaskExecutor applicationTaskExecutor) {
        return new ExecutorServiceMetrics((ExecutorService)applicationTaskExecutor.getThreadPoolExecutor(), applicationTaskExecutor.getThreadNamePrefix(), "import_threads", (Iterable)Tags.empty());
    }
}

