/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.parameters.adapters;

import java.util.Iterator;
import org.dmfs.iterators.AbstractConvertedIterator;
import org.dmfs.iterators.ConvertedIterator;
import org.dmfs.iterators.EmptyIterator;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.parameters.Parameter;
import org.dmfs.rfc3986.parameters.ParameterList;
import org.dmfs.rfc3986.parameters.parameters.UrlEncodedParameter;
import org.dmfs.rfc3986.utils.Split;

public final class XwfueParameterList
implements ParameterList {
    private static final AbstractConvertedIterator.Converter<Parameter, CharSequence> CONVERTER = new AbstractConvertedIterator.Converter<Parameter, CharSequence>(){

        public Parameter convert(CharSequence element) {
            return new UrlEncodedParameter(new Precoded(element));
        }
    };
    private final Optional<UriEncoded> mDelegate;

    public XwfueParameterList(UriEncoded delegate) {
        this((Optional<UriEncoded>)new Present((Object)delegate));
    }

    public XwfueParameterList(Optional<UriEncoded> delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public Iterator<Parameter> iterator() {
        if (!this.mDelegate.isPresent() || ((UriEncoded)this.mDelegate.value()).length() == 0) {
            return EmptyIterator.instance();
        }
        return new ConvertedIterator((Iterator)((Object)new Split((CharSequence)this.mDelegate.value(), '&')), CONVERTER);
    }
}

