/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.parameters.parametertypes;

import org.dmfs.rfc3986.parameters.Parameter;
import org.dmfs.rfc3986.parameters.ParameterType;
import org.dmfs.rfc3986.parameters.ValueType;

public final class BasicParameterType<T>
implements ParameterType<T> {
    private final CharSequence mName;
    private final ValueType<T> mValueType;

    public BasicParameterType(CharSequence name, ValueType<T> valueType) {
        this.mName = name;
        this.mValueType = valueType;
    }

    @Override
    public CharSequence name() {
        return this.mName;
    }

    @Override
    public T value(Parameter parameter) {
        if (!this.name().toString().equals(parameter.name().toString())) {
            throw new IllegalArgumentException(String.format("Given parameter has wrong type \"%s\". Expected type \"%s\"", parameter.name().toString(), this.mName.toString()));
        }
        return this.mValueType.parsedValue(parameter.textValue());
    }

    @Override
    public Parameter parameter(final T value) {
        return new Parameter(){

            @Override
            public CharSequence name() {
                return BasicParameterType.this.mName;
            }

            @Override
            public CharSequence textValue() {
                return BasicParameterType.this.mValueType.serializedValue(value);
            }
        };
    }
}

