/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.service;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.qubership.atp.integration.configuration.helpers.HttpRequestParseHelper;
import org.qubership.atp.integration.configuration.helpers.JwtParseHelper;
import org.qubership.atp.integration.configuration.protos.KafkaAuditLoggingMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;

public class AuditLoggingService {
    private static final Logger log = LoggerFactory.getLogger(AuditLoggingService.class);
    public static final String PROJECT_ID_HEADER_NAME = "X-Project-Id";
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${atp.audit.logging.topic.name}")
    private String topic;
    private final Producer<UUID, KafkaAuditLoggingMessage.AuditLoggingMessage> auditLoggingKafkaProducer;
    private final JwtParseHelper jwtParseHelper;
    private final HttpRequestParseHelper httpRequestParseHelper;

    public void loggingRequest(HttpServletRequest request, HttpServletResponse response) {
        log.debug("Trying to log request");
        try {
            KafkaAuditLoggingMessage.AuditLoggingMessage message;
            String url = request.getRequestURI();
            UUID id = UUID.randomUUID();
            UUID projectId = this.httpRequestParseHelper.getRequestUuidHeader(request, PROJECT_ID_HEADER_NAME, false);
            String authToken = request.getHeader("Authorization");
            UUID sessionId = this.jwtParseHelper.getSessionIdFromToken(authToken);
            String username = this.jwtParseHelper.getUsernameFromToken(authToken);
            UUID userId = this.jwtParseHelper.getUserIdFromToken(authToken);
            Timestamp startDate = new Timestamp(System.currentTimeMillis());
            String httpMethod = request.getMethod();
            String refererPage = request.getHeader("referer");
            String ipAddress = request.getRemoteAddr();
            String userAgent = this.httpRequestParseHelper.getBrowserAgent(request.getHeader("User-Agent"));
            int httpStatusCode = response.getStatus();
            HashMap mdcMap = MDC.getCopyOfContextMap();
            if (mdcMap == null) {
                mdcMap = new HashMap();
            }
            if (!(message = KafkaAuditLoggingMessage.AuditLoggingMessage.newBuilder().setId(id.toString()).setSessionId(StringUtils.defaultString((String)sessionId.toString(), (String)"null")).setProjectId(StringUtils.defaultString((String)projectId.toString(), (String)"null")).setService(StringUtils.defaultString((String)this.serviceName, (String)"null")).setUsername(StringUtils.defaultString((String)username, (String)"null")).setUserId(userId.toString()).setUrl(StringUtils.defaultString((String)url, (String)"null")).setStartDate(startDate.getTime()).setHttpMethod(StringUtils.defaultString((String)httpMethod, (String)"null")).setReferPage(StringUtils.defaultString((String)refererPage, (String)"null")).setIpAddress(StringUtils.defaultString((String)ipAddress, (String)"null")).setUserAgent(userAgent).setUserAction(StringUtils.defaultString((String)((String)mdcMap.get("userAction")), (String)"null")).setHttpStatusCode(httpStatusCode).build()).getUserAction().equals("null")) {
                ProducerRecord record = new ProducerRecord(this.topic, (Object)sessionId, (Object)message);
                this.auditLoggingKafkaProducer.send(record);
                log.debug("Request have been successfully logged");
            }
        }
        catch (Exception err) {
            log.error("Failed to log request", (Throwable)err);
        }
    }

    public AuditLoggingService(Producer<UUID, KafkaAuditLoggingMessage.AuditLoggingMessage> auditLoggingKafkaProducer, JwtParseHelper jwtParseHelper, HttpRequestParseHelper httpRequestParseHelper) {
        this.auditLoggingKafkaProducer = auditLoggingKafkaProducer;
        this.jwtParseHelper = jwtParseHelper;
        this.httpRequestParseHelper = httpRequestParseHelper;
    }
}

