/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.qubership.atp.integration.configuration.feign.MailSenderFeignClient;
import org.qubership.atp.integration.configuration.model.MailRequest;
import org.qubership.atp.integration.configuration.model.MailResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.multipart.MultipartFile;

public class MailSenderService {
    private static final Logger log = LoggerFactory.getLogger(MailSenderService.class);
    private final KafkaTemplate<UUID, MailRequest> kafkaTemplate;
    private final MailSenderFeignClient mailSenderFeignClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Value(value="${kafka.mails.topic:ci_mails}")
    private String mailRequestTopic;
    @Value(value="${spring.application.name}")
    private String serviceName;

    public MailResponse send(MailRequest mail) {
        if (StringUtils.isEmpty((Object)mail.getService())) {
            mail.setService(this.serviceName);
        }
        if (this.kafkaTemplate == null) {
            return this.sendViaRest(mail);
        }
        return this.sendViaKafka(mail);
    }

    public MailResponse send(MailRequest mail, List<MultipartFile> attachments) {
        if (StringUtils.isEmpty((Object)mail.getService())) {
            mail.setService(this.serviceName);
        }
        return this.sendViaRest(mail, attachments, null);
    }

    public MailResponse send(MailRequest mail, List<MultipartFile> attachments, List<MultipartFile> inlines) {
        if (StringUtils.isEmpty((Object)mail.getService())) {
            mail.setService(this.serviceName);
        }
        return this.sendViaRest(mail, attachments, inlines);
    }

    public MailResponse sendWithInline(MailRequest mail, List<MultipartFile> inlines) {
        if (StringUtils.isEmpty((Object)mail.getService())) {
            mail.setService(this.serviceName);
        }
        return this.sendViaRest(mail, null, inlines);
    }

    private MailResponse sendViaRest(MailRequest mail) {
        MailResponse mailResponse = new MailResponse();
        try {
            ResponseEntity response = this.mailSenderFeignClient.send(mail);
            mailResponse.setStatus(response.getStatusCodeValue());
            mailResponse.setMessage("Mail sent successfully");
        }
        catch (Exception ex) {
            log.error("Failed to send mail", (Throwable)ex);
            mailResponse = this.getMailResponse(ex);
        }
        return mailResponse;
    }

    private MailResponse sendViaRest(MailRequest mail, List<MultipartFile> attachments, List<MultipartFile> inlines) {
        MailResponse mailResponse = new MailResponse();
        try {
            ResponseEntity response = this.mailSenderFeignClient.sendWithAttachment(this.objectMapper.writeValueAsString((Object)mail), attachments, inlines);
            mailResponse.setStatus(response.getStatusCodeValue());
            mailResponse.setMessage("Mail sent successfully");
        }
        catch (Exception ex) {
            log.error("Failed to send mail", (Throwable)ex);
            mailResponse = this.getMailResponse(ex);
        }
        return mailResponse;
    }

    private MailResponse getMailResponse(Exception ex) {
        MailResponse mailResponse = new MailResponse();
        String errorMessage = ex.toString();
        String errorMessageBody = errorMessage.substring(errorMessage.indexOf("{"));
        if (!StringUtils.isEmpty((Object)errorMessageBody)) {
            try {
                mailResponse = (MailResponse)this.objectMapper.readValue(errorMessageBody, MailResponse.class);
            }
            catch (JsonProcessingException e) {
                log.warn("Can't cast exception message to MailResponse type: " + (Object)((Object)e));
                mailResponse.setStatus(500);
                mailResponse.setMessage("Failed to send mail. Undefined error");
                mailResponse.setTimestamp(new Date());
                mailResponse.setTrace(Arrays.toString(ex.getStackTrace()));
            }
        }
        return mailResponse;
    }

    private MailResponse sendViaKafka(MailRequest mail) {
        MailResponse response = new MailResponse();
        response.setTimestamp(new Date());
        try {
            ListenableFuture future = this.kafkaTemplate.send(this.mailRequestTopic, (Object)mail);
            future.get();
            response.setStatus(200);
            response.setMessage("Mail request successfully sent to kafka");
        }
        catch (RecordTooLargeException ex) {
            log.warn("The mail is too big to send to kafka. Send it via REST");
            return this.sendViaRest(mail);
        }
        catch (Exception ex) {
            log.error("Failed to send mail to kafka topic", (Throwable)ex);
            response.setStatus(500);
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    public MailSenderService(KafkaTemplate<UUID, MailRequest> kafkaTemplate, MailSenderFeignClient mailSenderFeignClient) {
        this.kafkaTemplate = kafkaTemplate;
        this.mailSenderFeignClient = mailSenderFeignClient;
    }
}

