/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoJsonSchemaCreator;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.Encrypted;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.schema.IdentifiableJsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.JsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.schema.TypedJsonSchemaObject;
import org.springframework.data.mongodb.core.schema.UntypedJsonSchemaObject;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class MappingMongoJsonSchemaCreator
implements MongoJsonSchemaCreator {
    private final MongoConverter converter;
    private final MappingContext<MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final Predicate<MongoJsonSchemaCreator.JsonSchemaPropertyContext> filter;
    private final LinkedMultiValueMap<String, Class<?>> mergeProperties;

    MappingMongoJsonSchemaCreator(MongoConverter converter) {
        this(converter, converter.getMappingContext(), property -> true, new LinkedMultiValueMap());
    }

    MappingMongoJsonSchemaCreator(MongoConverter converter, MappingContext<MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, Predicate<MongoJsonSchemaCreator.JsonSchemaPropertyContext> filter, LinkedMultiValueMap<String, Class<?>> mergeProperties) {
        Assert.notNull((Object)converter, (String)"Converter must not be null!");
        this.converter = converter;
        this.mappingContext = mappingContext;
        this.filter = filter;
        this.mergeProperties = mergeProperties;
    }

    @Override
    public MongoJsonSchemaCreator filter(Predicate<MongoJsonSchemaCreator.JsonSchemaPropertyContext> filter) {
        return new MappingMongoJsonSchemaCreator(this.converter, this.mappingContext, filter, this.mergeProperties);
    }

    @Override
    public MongoJsonSchemaCreator.PropertySpecifier property(String path) {
        return types -> this.withTypesFor(path, types);
    }

    public MongoJsonSchemaCreator withTypesFor(String path, Class<?> ... types) {
        LinkedMultiValueMap clone = this.mergeProperties.clone();
        for (Class<?> type : types) {
            clone.add((Object)path, type);
        }
        return new MappingMongoJsonSchemaCreator(this.converter, this.mappingContext, this.filter, clone);
    }

    @Override
    public MongoJsonSchema createSchemaFor(Class<?> type) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        MongoJsonSchema.MongoJsonSchemaBuilder schemaBuilder = MongoJsonSchema.builder();
        Encrypted encrypted = (Encrypted)entity.findAnnotation(Encrypted.class);
        if (encrypted != null) {
            Document encryptionMetadata = new Document();
            Collection<Object> encryptionKeyIds = entity.getEncryptionKeyIds();
            if (!CollectionUtils.isEmpty(encryptionKeyIds)) {
                encryptionMetadata.append("keyId", encryptionKeyIds);
            }
            if (StringUtils.hasText((String)encrypted.algorithm())) {
                encryptionMetadata.append("algorithm", (Object)encrypted.algorithm());
            }
            schemaBuilder.encryptionMetadata(encryptionMetadata);
        }
        List<JsonSchemaProperty> schemaProperties = this.computePropertiesForEntity(Collections.emptyList(), entity);
        schemaBuilder.properties(schemaProperties.toArray(new JsonSchemaProperty[0]));
        return schemaBuilder.build();
    }

    private List<JsonSchemaProperty> computePropertiesForEntity(List<MongoPersistentProperty> path, MongoPersistentEntity<?> entity) {
        ArrayList<JsonSchemaProperty> schemaProperties = new ArrayList<JsonSchemaProperty>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty nested = (MongoPersistentProperty)iterator.next();
            ArrayList<MongoPersistentProperty> currentPath = new ArrayList<MongoPersistentProperty>(path);
            String stringPath = currentPath.stream().map(PersistentProperty::getName).collect(Collectors.joining("."));
            String string = stringPath = StringUtils.hasText((String)stringPath) ? stringPath + "." + nested.getName() : nested.getName();
            if (!this.filter.test(new PropertyContext(stringPath, nested)) && !this.mergeProperties.containsKey((Object)stringPath)) continue;
            if (path.contains(nested)) {
                schemaProperties.add(this.createSchemaProperty(this.computePropertyFieldName((PersistentProperty)CollectionUtils.lastElement(currentPath)), Object.class, false));
                break;
            }
            currentPath.add(nested);
            schemaProperties.add(this.computeSchemaForProperty(currentPath));
        }
        return schemaProperties;
    }

    private JsonSchemaProperty computeSchemaForProperty(List<MongoPersistentProperty> path) {
        String stringPath = path.stream().map(PersistentProperty::getName).collect(Collectors.joining("."));
        MongoPersistentProperty property = (MongoPersistentProperty)CollectionUtils.lastElement(path);
        boolean required = this.isRequiredProperty(property);
        Class<?> rawTargetType = this.computeTargetType(property);
        Class<?> targetType = this.converter.getTypeMapper().getWriteTargetTypeFor(rawTargetType);
        if (!MappingMongoJsonSchemaCreator.isCollection(property) && ObjectUtils.nullSafeEquals(rawTargetType, targetType) && (property.isEntity() || this.mergeProperties.containsKey((Object)stringPath))) {
            ArrayList<JsonSchemaProperty> targetProperties = new ArrayList<JsonSchemaProperty>();
            if (property.isEntity()) {
                targetProperties.add(this.createObjectSchemaPropertyForEntity(path, property, required));
            }
            if (this.mergeProperties.containsKey((Object)stringPath)) {
                for (Class theType : this.mergeProperties.get((Object)stringPath)) {
                    IdentifiableJsonSchemaProperty.ObjectJsonSchemaProperty target = JsonSchemaProperty.object(property.getName());
                    List<JsonSchemaProperty> nestedProperties = this.computePropertiesForEntity(path, (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(theType));
                    targetProperties.add(MappingMongoJsonSchemaCreator.createPotentiallyRequiredSchemaProperty(target.properties(nestedProperties.toArray(new JsonSchemaProperty[0])), required));
                }
            }
            JsonSchemaProperty schemaProperty = targetProperties.size() == 1 ? (JsonSchemaProperty)targetProperties.iterator().next() : JsonSchemaProperty.merged(targetProperties);
            return this.applyEncryptionDataIfNecessary(property, schemaProperty);
        }
        String fieldName = this.computePropertyFieldName(property);
        JsonSchemaProperty schemaProperty = MappingMongoJsonSchemaCreator.isCollection(property) ? this.createArraySchemaProperty(fieldName, property, required) : (property.isMap() ? this.createSchemaProperty(fieldName, JsonSchemaObject.Type.objectType(), required) : (ClassUtils.isAssignable(Enum.class, targetType) ? this.createEnumSchemaProperty(fieldName, targetType, required) : this.createSchemaProperty(fieldName, targetType, required)));
        return this.applyEncryptionDataIfNecessary(property, schemaProperty);
    }

    private JsonSchemaProperty createArraySchemaProperty(String fieldName, MongoPersistentProperty property, boolean required) {
        IdentifiableJsonSchemaProperty.ArrayJsonSchemaProperty schemaProperty = JsonSchemaProperty.array(fieldName);
        if (this.isSpecificType(property)) {
            schemaProperty = this.potentiallyEnhanceArraySchemaProperty(property, schemaProperty);
        }
        return MappingMongoJsonSchemaCreator.createPotentiallyRequiredSchemaProperty(schemaProperty, required);
    }

    private IdentifiableJsonSchemaProperty.ArrayJsonSchemaProperty potentiallyEnhanceArraySchemaProperty(MongoPersistentProperty property, IdentifiableJsonSchemaProperty.ArrayJsonSchemaProperty schemaProperty) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(property.getTypeInformation().getRequiredComponentType());
        if (persistentEntity != null) {
            List<JsonSchemaProperty> nestedProperties = this.computePropertiesForEntity(Collections.emptyList(), persistentEntity);
            if (nestedProperties.isEmpty()) {
                return schemaProperty;
            }
            return schemaProperty.items(JsonSchemaObject.object().properties(nestedProperties.toArray(new JsonSchemaProperty[0])));
        }
        if (ClassUtils.isAssignable(Enum.class, (Class)property.getActualType())) {
            List<Object> possibleValues = this.getPossibleEnumValues(property.getActualType());
            return schemaProperty.items(this.createSchemaObject(MappingMongoJsonSchemaCreator.computeTargetType(property.getActualType(), possibleValues), possibleValues));
        }
        return schemaProperty.items(JsonSchemaObject.of(property.getActualType()));
    }

    private boolean isSpecificType(MongoPersistentProperty property) {
        return !ClassTypeInformation.OBJECT.equals((Object)property.getTypeInformation().getActualType());
    }

    private JsonSchemaProperty applyEncryptionDataIfNecessary(MongoPersistentProperty property, JsonSchemaProperty schemaProperty) {
        Encrypted encrypted = (Encrypted)property.findAnnotation(Encrypted.class);
        if (encrypted == null) {
            return schemaProperty;
        }
        IdentifiableJsonSchemaProperty.EncryptedJsonSchemaProperty enc = new IdentifiableJsonSchemaProperty.EncryptedJsonSchemaProperty(schemaProperty);
        if (StringUtils.hasText((String)encrypted.algorithm())) {
            enc = enc.algorithm(encrypted.algorithm());
        }
        if (!ObjectUtils.isEmpty((Object[])encrypted.keyId())) {
            enc = enc.keys(property.getEncryptionKeyIds());
        }
        return enc;
    }

    private JsonSchemaProperty createObjectSchemaPropertyForEntity(List<MongoPersistentProperty> path, MongoPersistentProperty property, boolean required) {
        IdentifiableJsonSchemaProperty.ObjectJsonSchemaProperty target = JsonSchemaProperty.object(property.getName());
        List<JsonSchemaProperty> nestedProperties = this.computePropertiesForEntity(path, (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property));
        return MappingMongoJsonSchemaCreator.createPotentiallyRequiredSchemaProperty(target.properties(nestedProperties.toArray(new JsonSchemaProperty[0])), required);
    }

    private JsonSchemaProperty createEnumSchemaProperty(String fieldName, Class<?> targetType, boolean required) {
        List<Object> possibleValues = this.getPossibleEnumValues(targetType);
        targetType = MappingMongoJsonSchemaCreator.computeTargetType(targetType, possibleValues);
        return this.createSchemaProperty(fieldName, targetType, required, possibleValues);
    }

    JsonSchemaProperty createSchemaProperty(String fieldName, Object type, boolean required) {
        return this.createSchemaProperty(fieldName, type, required, Collections.emptyList());
    }

    JsonSchemaProperty createSchemaProperty(String fieldName, Object type, boolean required, Collection<?> possibleValues) {
        TypedJsonSchemaObject schemaObject = this.createSchemaObject(type, possibleValues);
        return MappingMongoJsonSchemaCreator.createPotentiallyRequiredSchemaProperty(JsonSchemaProperty.named(fieldName).with(schemaObject), required);
    }

    private TypedJsonSchemaObject createSchemaObject(Object type, Collection<?> possibleValues) {
        UntypedJsonSchemaObject schemaObject;
        TypedJsonSchemaObject typedJsonSchemaObject = schemaObject = type instanceof JsonSchemaObject.Type ? JsonSchemaObject.of((JsonSchemaObject.Type)JsonSchemaObject.Type.class.cast(type)) : JsonSchemaObject.of((Class)Class.class.cast(type));
        if (!CollectionUtils.isEmpty(possibleValues)) {
            schemaObject = schemaObject.possibleValues(possibleValues);
        }
        return schemaObject;
    }

    private String computePropertyFieldName(PersistentProperty property) {
        return property instanceof MongoPersistentProperty ? ((MongoPersistentProperty)property).getFieldName() : property.getName();
    }

    private boolean isRequiredProperty(PersistentProperty property) {
        return property.getType().isPrimitive();
    }

    private Class<?> computeTargetType(PersistentProperty<?> property) {
        if (!(property instanceof MongoPersistentProperty)) {
            return property.getType();
        }
        MongoPersistentProperty mongoProperty = (MongoPersistentProperty)property;
        if (!mongoProperty.isIdProperty()) {
            return mongoProperty.getFieldType();
        }
        if (mongoProperty.hasExplicitWriteTarget()) {
            return ((Field)mongoProperty.getRequiredAnnotation(Field.class)).targetType().getJavaClass();
        }
        return mongoProperty.getFieldType() != mongoProperty.getActualType() ? Object.class : mongoProperty.getFieldType();
    }

    private static Class<?> computeTargetType(Class<?> fallback, List<Object> possibleValues) {
        return possibleValues.isEmpty() ? fallback : possibleValues.iterator().next().getClass();
    }

    private <E extends Enum<E>> List<Object> getPossibleEnumValues(Class<E> targetType) {
        EnumSet<E> enumSet = EnumSet.allOf(targetType);
        ArrayList<Object> possibleValues = new ArrayList<Object>(enumSet.size());
        for (Object enumValue : enumSet) {
            possibleValues.add(this.converter.convertToMongoType(enumValue));
        }
        return possibleValues;
    }

    private static boolean isCollection(MongoPersistentProperty property) {
        return property.isCollectionLike() && !property.getType().equals(byte[].class);
    }

    static JsonSchemaProperty createPotentiallyRequiredSchemaProperty(JsonSchemaProperty property, boolean required) {
        return required ? JsonSchemaProperty.required(property) : property;
    }

    class PropertyContext
    implements MongoJsonSchemaCreator.JsonSchemaPropertyContext {
        private final String path;
        private final MongoPersistentProperty property;

        public PropertyContext(String path, MongoPersistentProperty property) {
            this.path = path;
            this.property = property;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public MongoPersistentProperty getProperty() {
            return this.property;
        }

        @Override
        public <T> MongoPersistentEntity<T> resolveEntity(MongoPersistentProperty property) {
            return (MongoPersistentEntity)MappingMongoJsonSchemaCreator.this.mappingContext.getPersistentEntity((PersistentProperty)property);
        }
    }
}

