/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.dto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.ei.ntt.dto.Dictionary;

public class Directive
extends Dictionary {
    protected final Map<DirectiveParameter, String> parameters = new HashMap<DirectiveParameter, String>();

    public Directive(UUID id, String name, String description) {
        super(id, name, description);
    }

    public void addParameter(DirectiveParameter key, String value) {
        this.parameters.put(key, value);
    }

    public String getParameter(DirectiveParameter key) {
        return this.parameters.get((Object)key);
    }

    public Map<DirectiveParameter, String> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Directive)) {
            return false;
        }
        Directive other = (Directive)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<DirectiveParameter, String> this$parameters = this.getParameters();
        Map<DirectiveParameter, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Directive;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<DirectiveParameter, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Directive(parameters=" + this.getParameters() + ")";
    }

    public Directive() {
    }

    public static enum DirectiveParameter {
        VALUE("value"),
        ATTEMPTS("attempts"),
        MAXTIME("maxtime");

        private String key;
        private static final Map<String, DirectiveParameter> byKeyIndex;

        private DirectiveParameter(String key) {
            this.key = key;
        }

        public static DirectiveParameter findByKey(String key) {
            Preconditions.checkNotNull((Object)((Object)byKeyIndex.get(key.toLowerCase())), (String)"DirectiveParameter with key %key does not exist", (Object)key);
            return byKeyIndex.get(key);
        }

        public String getKey() {
            return this.key;
        }

        static {
            byKeyIndex = Maps.newHashMapWithExpectedSize((int)DirectiveParameter.values().length);
            for (DirectiveParameter param : DirectiveParameter.values()) {
                byKeyIndex.put(param.getKey(), param);
            }
        }
    }
}

