/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.model.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.ei.ntt.model.ModelItem;
import org.qubership.atp.ei.ntt.model.NttTestCase;
import org.qubership.atp.ei.ntt.model.Project;
import org.qubership.atp.ei.ntt.model.Reference;
import org.qubership.atp.ei.ntt.model.Template;
import org.qubership.atp.ei.ntt.model.TemplateProject;
import org.qubership.atp.ei.ntt.model.TestAction;
import org.qubership.atp.ei.ntt.model.TestStep;
import org.qubership.atp.ei.ntt.model.TestSuite;
import org.qubership.atp.ei.ntt.model.TreeNode;
import org.qubership.atp.ei.ntt.model.impl.AbstractTreeNode;
import org.qubership.atp.ei.ntt.model.impl.ReferenceModelItem;
import org.qubership.atp.ei.ntt.model.impl.TestActionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelItem
extends AbstractTreeNode
implements ModelItem {
    private static final Logger log = LoggerFactory.getLogger(AbstractModelItem.class);
    private boolean isEnable = true;
    private boolean isWanted = false;

    @Override
    public Project getProject() {
        TreeNode item;
        if (this instanceof Project) {
            return (Project)((Object)this);
        }
        for (item = this.getParent(); !(item instanceof Project) && item != null; item = item.getParent()) {
        }
        return (Project)item;
    }

    @Override
    public boolean isTemplate() {
        for (TreeNode tmp = this; tmp != null; tmp = tmp.getParent()) {
            if (!(tmp instanceof Template)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReference() {
        for (TreeNode tmp = this; tmp != null; tmp = tmp.getParent()) {
            if (!(tmp instanceof Reference)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Template getTemplate() {
        for (TreeNode tmp = this; tmp != null; tmp = tmp.getParent()) {
            if (tmp instanceof Template) {
                return (Template)tmp;
            }
            if (!(tmp instanceof ReferenceModelItem)) continue;
            return ((ReferenceModelItem)tmp).getTemplate();
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnable;
    }

    @Override
    public void setEnabled(boolean isEnable) {
        this.isEnable = isEnable;
    }

    @Override
    public boolean isWanted() {
        return this.isWanted;
    }

    @Override
    public void setWanted(boolean isWanted) {
        this.isWanted = isWanted;
    }

    public List<? extends TestAction> getActions() {
        return this.getAllActionsFromModelItem(this);
    }

    private List<TestAction> getAllActionsFromModelItem(ModelItem item) {
        ArrayList<TestAction> results = new ArrayList<TestAction>();
        for (TreeNode node : item.getChildren()) {
            if (node instanceof TestAction) {
                results.add((TestActionModel)node);
                continue;
            }
            results.addAll(this.getAllActionsFromModelItem((ModelItem)node));
        }
        return results;
    }

    public static class Helper {
        private static final Multimap<Class<? extends ModelItem>, Class<? extends ModelItem>> parentAcceptsChild = ArrayListMultimap.create((int)10, (int)5);

        public static boolean childCanBeAccepted(ModelItem child, ModelItem possibleParent) {
            if (child == null) {
                return false;
            }
            Class<?> possibleParentClass = possibleParent.getClass() == Reference.class ? possibleParent.getClass() : possibleParent.getClass();
            Class parClass = null;
            for (Class parentClass : parentAcceptsChild.keySet()) {
                if (!parentClass.isAssignableFrom(possibleParentClass)) continue;
                boolean toBeBroken = false;
                for (Class superParentClass : parentAcceptsChild.keySet()) {
                    if (!superParentClass.isAssignableFrom(parentClass) || superParentClass.equals(parentClass)) continue;
                    toBeBroken = true;
                    break;
                }
                parClass = parentClass;
                if (!toBeBroken) continue;
                break;
            }
            Class<?> childClass = child.getClass() == ReferenceModelItem.class ? child.getTemplate().getModelItem().getClass() : child.getClass();
            for (Class assClass : parentAcceptsChild.get(parClass)) {
                if (!assClass.isAssignableFrom(childClass)) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.error("Sleep has been interrupted", (Throwable)e);
                }
                return true;
            }
            return false;
        }

        static {
            parentAcceptsChild.put(TestStep.class, TestAction.class);
            parentAcceptsChild.put(NttTestCase.class, TestStep.class);
            parentAcceptsChild.put(TestSuite.class, NttTestCase.class);
            parentAcceptsChild.put(Project.class, TestSuite.class);
            parentAcceptsChild.put(TemplateProject.class, Template.class);
            parentAcceptsChild.put(NttTestCase.class, Reference.class);
            parentAcceptsChild.put(TestSuite.class, Reference.class);
            parentAcceptsChild.put(Project.class, Reference.class);
        }
    }
}

