/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.query;

import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.query.DeleteQuery;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.InsertWithAutoincrement;
import org.polyjdbc.core.query.InsertWithSequence;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.UpdateQuery;
import org.polyjdbc.core.type.ColumnTypeMapper;

public class QueryFactory {
    private final Dialect dialect;
    private final ColumnTypeMapper typeMapper;

    public QueryFactory(Dialect dialect, ColumnTypeMapper typeMapper) {
        this.dialect = dialect;
        this.typeMapper = typeMapper;
    }

    public InsertQuery insert() {
        if (this.dialect.supportsSequences()) {
            return new InsertWithSequence(this.typeMapper);
        }
        return new InsertWithAutoincrement(this.typeMapper);
    }

    public SelectQuery select(String what) {
        return new SelectQuery(this.dialect, this.typeMapper, what);
    }

    public SelectQuery selectAll() {
        return new SelectQuery(this.dialect, this.typeMapper, "*");
    }

    public SelectQuery select() {
        return new SelectQuery(this.dialect, this.typeMapper);
    }

    public UpdateQuery update(String what) {
        return new UpdateQuery(this.typeMapper, what);
    }

    public DeleteQuery delete() {
        return new DeleteQuery(this.typeMapper);
    }
}

