/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.dialect.MsSqlDialect;
import org.polyjdbc.core.exception.SchemaInspectionException;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.transaction.Transaction;

class SchemaInspectorImpl
implements SchemaInspector {
    private Locale locale;
    private final Transaction transaction;
    private DatabaseMetaData metadata;
    private String catalog;
    private String schemaName;
    private final Dialect dialect;

    SchemaInspectorImpl(Transaction transaction) {
        this(transaction, Locale.ENGLISH);
    }

    SchemaInspectorImpl(Transaction transaction, Locale locale) {
        this(transaction, locale, null, null);
    }

    SchemaInspectorImpl(Transaction transaction, String schemaName, Dialect dialect) {
        this(transaction, Locale.ENGLISH, schemaName, dialect);
    }

    SchemaInspectorImpl(Transaction transaction, Locale locale, String schemaName, Dialect dialect) {
        this.transaction = transaction;
        this.locale = locale;
        this.schemaName = schemaName;
        this.dialect = dialect;
        this.extractMetadata(transaction);
    }

    private void extractMetadata(Transaction transaction) {
        try {
            Connection connection = transaction.getConnection();
            this.metadata = connection.getMetaData();
            this.catalog = connection.getCatalog();
        }
        catch (SQLException exception) {
            throw new SchemaInspectionException("METADATA_EXTRACTION_ERROR", "Failed to obtain metadata from connection.", exception);
        }
    }

    @Override
    public boolean relationExists(String name) {
        try {
            ResultSet resultSet = this.metadata.getTables(this.catalog, this.schemaName, this.convertCase(name), new String[]{"TABLE"});
            this.transaction.registerCursor(resultSet);
            if (this.schemaName != null) {
                return resultSet.next();
            }
            while (resultSet.next()) {
                String tableSchemaName = resultSet.getString("TABLE_SCHEM");
                if (tableSchemaName != null && !tableSchemaName.equalsIgnoreCase("public") && !tableSchemaName.equals("") && (!(this.dialect instanceof MsSqlDialect) || !tableSchemaName.equalsIgnoreCase("dbo"))) continue;
                return true;
            }
            return false;
        }
        catch (SQLException exception) {
            throw new SchemaInspectionException("RELATION_LOOKUP_ERROR", "Failed to obtain relation list when looking for relation " + name, exception);
        }
    }

    @Override
    public boolean indexExists(String relationName, String indexName) {
        try {
            ResultSet resultSet = this.metadata.getIndexInfo(this.catalog, this.schemaName, this.convertCase(relationName), false, true);
            this.transaction.registerCursor(resultSet);
            String normalizedIndexName = this.convertCase(indexName);
            while (resultSet.next()) {
                String rsetIndexName = resultSet.getString("INDEX_NAME");
                if (rsetIndexName == null || !rsetIndexName.equals(normalizedIndexName)) continue;
                return true;
            }
            return false;
        }
        catch (SQLException exception) {
            throw new SchemaInspectionException("INDEX_LOOKUP_ERROR", "Failed to obtain relation index list when looking for indexes for relation " + relationName, exception);
        }
    }

    private String convertCase(String identifier) throws SQLException {
        if (this.metadata.storesLowerCaseIdentifiers()) {
            return identifier.toLowerCase(this.locale);
        }
        if (this.metadata.storesUpperCaseIdentifiers()) {
            return identifier.toUpperCase(this.locale);
        }
        return identifier;
    }

    @Override
    public void close() {
        this.transaction.commit();
        this.transaction.close();
    }
}

