/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.antlr4;

import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.qubership.atp.dataset.antlr.DataSetParameterLexer;
import org.qubership.atp.dataset.antlr.DataSetParameterParser;
import org.qubership.atp.dataset.antlr4.MacroListener;
import org.qubership.atp.dataset.antlr4.ParameterListener;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractTextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.TextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.macros.core.parser.antlr4.MacrosLexer;
import org.qubership.atp.macros.core.parser.antlr4.MacrosParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextParameterParser {
    private static final Logger log = LoggerFactory.getLogger(TextParameterParser.class);
    private static final Logger LOG = LoggerFactory.getLogger(TextParameterParser.class);
    private MacroContext context;
    private ParameterPositionContext parameterPositionContext;

    public TextParameterParser(MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        this.context = macroContext;
        this.parameterPositionContext = parameterPositionContext;
    }

    public List<AbstractTextParameter> parse(String textToParse, boolean setEvaluate) {
        return this.parseUsingExternalParser(textToParse, setEvaluate);
    }

    @Deprecated
    public List<AbstractTextParameter> parseUsingEmbeddedParser(String textToParse, boolean setEvaluate) {
        try {
            DataSetParameterLexer lexer = new DataSetParameterLexer((CharStream)CharStreams.fromString((String)textToParse));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            DataSetParameterParser parser = new DataSetParameterParser((TokenStream)tokens);
            DataSetParameterParser.ParameterContext tree = parser.parameter();
            ParseTreeWalker walker = new ParseTreeWalker();
            ParameterListener parameterListener = new ParameterListener(this.context, this.parameterPositionContext, setEvaluate);
            walker.walk((ParseTreeListener)parameterListener, (ParseTree)tree);
            return parameterListener.getParsedParameters();
        }
        catch (Exception e) {
            LOG.debug("Text parameter parse error", (Throwable)e);
            return Collections.singletonList(new TextParameter("Parse error", this.parameterPositionContext));
        }
    }

    public List<AbstractTextParameter> parseUsingExternalParser(String textToParse, boolean setEvaluate) {
        try {
            MacrosLexer lexer = new MacrosLexer((CharStream)CharStreams.fromString((String)textToParse));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            MacrosParser parser = new MacrosParser((TokenStream)tokens);
            MacrosParser.BodyContext body = parser.body();
            ParseTreeWalker walker = new ParseTreeWalker();
            MacroListener parameterListener = new MacroListener(this.context, this.parameterPositionContext, setEvaluate);
            walker.walk((ParseTreeListener)parameterListener, (ParseTree)body);
            return parameterListener.getParsedParameters();
        }
        catch (Exception e) {
            LOG.debug("Text parameter parse error '" + textToParse + "'", (Throwable)e);
            return Collections.singletonList(new TextParameter("Parse error", this.parameterPositionContext));
        }
    }
}

