/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLExceptionTranslator;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.spring.SpringExceptionTranslator;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import org.qubership.atp.dataset.config.listeners.ConnectionClosedListener;
import org.qubership.atp.dataset.db.DBConfig;
import org.qubership.atp.dataset.db.DbConfigImpl;
import org.qubership.atp.dataset.service.direct.helper.DbCreationFacade;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ComponentScan(value={"org.qubership.atp.dataset.db"})
@EnableJpaRepositories(value={"org.qubership.atp.dataset.db.jpa.repositories"})
public class DbConfiguration {
    @Bean
    public DBConfig dbConfig() {
        return new DbConfigImpl();
    }

    @Bean
    public DataSource dataSource(DBConfig dbconfig) {
        HikariConfig config = new HikariConfig();
        config.setLeakDetectionThreshold(TimeUnit.SECONDS.toMillis(dbconfig.getLeakDetectionThreshold()));
        config.setJdbcUrl(dbconfig.getJdbcUrl());
        config.setUsername(dbconfig.getUsername());
        config.setPassword(dbconfig.getPassword());
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.setMinimumIdle(dbconfig.getMinIdle());
        config.setMaximumPoolSize(dbconfig.getMaxPoolSize());
        config.setRegisterMbeans(dbconfig.isDebug());
        return new HikariDataSource(config);
    }

    @Bean
    public PlatformTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public com.querydsl.sql.Configuration qdslConfig(DataSource dataSource) {
        SQLTemplates templates = PostgreSQLTemplates.builder().build();
        com.querydsl.sql.Configuration configuration = new com.querydsl.sql.Configuration(templates);
        configuration.setExceptionTranslator((SQLExceptionTranslator)new SpringExceptionTranslator());
        configuration.addListener((SQLListener)new ConnectionClosedListener(dataSource));
        return configuration;
    }

    @Bean
    public SQLQueryFactory queryFactory(DataSource dataSource, com.querydsl.sql.Configuration qdslConfig) {
        return new SQLQueryFactory(qdslConfig, (DataSource)new TransactionAwareDataSourceProxy(dataSource));
    }

    @Bean
    public DbCreationFacade dbCreationFacade() {
        return new DbCreationFacade();
    }

    @Bean
    public LockProvider lockProvider(DataSource dataSource) {
        return new JdbcTemplateLockProvider(dataSource);
    }
}

