/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa.repositories;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaAbstractAttributeRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface JpaAttributeRepository
extends JpaAbstractAttributeRepository<AttributeEntity> {
    public List<AttributeEntity> getByNameAndDataSetListId(String var1, UUID var2);

    public List<AttributeEntity> getByDataSetListId(UUID var1);

    public List<AttributeEntity> getBySourceIdAndDataSetListId(UUID var1, UUID var2);

    public List<AttributeEntity> getByDataSetListIdIn(Collection<UUID> var1);

    public Page<AttributeEntity> getByTypeDataSetListId(UUID var1, Pageable var2);

    @Query(value="select count(a.id)  from \"attribute\" a where datasetlist_id = (select d.datasetlist_id  from dataset d where d.id = ?1)", nativeQuery=true)
    public int countAttributesByDataset(UUID var1);

    @Query(value="select * from \"attribute\" a where a.datasetlist_id = (select datasetlist_id from \"dataset\" d where d.id = ?1) and a.id not in (select attribute_id from \"parameter\" p where p.dataset_id = ?1)", nativeQuery=true)
    public List<AttributeEntity> getNotUsedByDatasetId(UUID var1);

    @Query(value="select * from \"attribute\" a where a.datasetlist_id = (select d.datasetlist_id from dataset d where d.id = ?1)", nativeQuery=true)
    public List<AttributeEntity> getByDatasetId(UUID var1);

    @Query(value="select \n   (CASE WHEN leftAttr.type_datasetlist_id  != rightAttr.type_datasetlist_id \n   and leftAttr.attribute_type_id = 4 \n   and leftAttr.attribute_type_id = rightAttr.attribute_type_id\n    THEN true ELSE false END) AS is_equal\n   from \n   (select * from \"attribute\" a2 where id = ?1) as leftAttr,\n    (select * from \"attribute\" a2 where id = ?2) as rightAttr", nativeQuery=true)
    public boolean isDifferentDslAttributes(UUID var1, UUID var2);

    @Query(value="SELECT * from \"attribute\" a WHERE a.datasetlist_id = ?1 AND a.attribute_type_id IN ?2 ORDER BY a.ordering", countQuery="SELECT COUNT(*) FROM \"attribute\" a WHERE a.datasetlist_id = ?1 AND a.attribute_type_id IN ?2", nativeQuery=true)
    public Page<AttributeEntity> findByEntityAndTypeIds(UUID var1, List<Long> var2, Pageable var3);
}

