/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.model.utils.tree.Leaf;
import org.qubership.atp.dataset.model.utils.tree.TraverseAndLeafsHandler;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;

public class DsParamHandler
implements TraverseAndLeafsHandler<DataSet, OverlapItem.Reachable, Leaf> {
    private final DsEvaluator evaluator;
    private final ParamDsHandler paramDs = new ParamDsHandler();
    private final LinkedList<DataSet> dsPath = new LinkedList();
    private final LinkedList<OverlapItem.Reachable> paramPath = new LinkedList();

    public DsParamHandler(DsEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    @Nonnull
    public TraverseAndLeafsHandler<?, DataSet, Leaf> backToPreviousParent() {
        this.paramPath.removeLast();
        return this.paramDs;
    }

    @Override
    @Nonnull
    public TraverseAndLeafsHandler<OverlapItem.Reachable, ?, Leaf> forwardToNewParent(@Nonnull DataSet parent) {
        this.dsPath.add(parent);
        return this.paramDs;
    }

    @Override
    @Nullable
    public Iterator<? extends OverlapItem.Reachable> getChildren(@Nonnull DataSet item) {
        List attrPath;
        DataSet rootDs;
        if (this.dsPath.isEmpty()) {
            rootDs = item;
            attrPath = Collections.emptyList();
        } else {
            rootDs = this.dsPath.getFirst();
            attrPath = this.paramPath.stream().map(p -> p.getAttribute().getId()).collect(Collectors.toList());
        }
        return item.getDataSetList().getAttributes().stream().map(attr -> {
            OverlapIterator overlapIterator = OverlapIterator.create(rootDs, attr.getId(), attrPath);
            return ((OverlapItem)overlapIterator.next()).asReachable();
        }).iterator();
    }

    @Override
    @Nullable
    public Leaf constructLeaf(@Nonnull DataSet leaf) {
        return null;
    }

    private class ParamDsHandler
    implements TraverseAndLeafsHandler<OverlapItem.Reachable, DataSet, Leaf> {
        private ParamDsHandler() {
        }

        @Override
        @Nonnull
        public TraverseAndLeafsHandler<?, OverlapItem.Reachable, Leaf> backToPreviousParent() {
            DsParamHandler.this.dsPath.removeLast();
            return DsParamHandler.this;
        }

        @Override
        @Nonnull
        public TraverseAndLeafsHandler<DataSet, ?, Leaf> forwardToNewParent(@Nonnull OverlapItem.Reachable parent) {
            DsParamHandler.this.paramPath.add(parent);
            return DsParamHandler.this;
        }

        @Override
        @Nullable
        public Iterator<? extends DataSet> getChildren(@Nonnull OverlapItem.Reachable item) {
            return item.getParameter().map(Parameter::getDataSetReference).map(Iterators::singletonIterator).orElse(null);
        }

        @Override
        @Nullable
        public Leaf constructLeaf(@Nonnull OverlapItem.Reachable leaf) {
            ArrayList path = Lists.newArrayListWithExpectedSize((int)(DsParamHandler.this.paramPath.size() + 1));
            DsParamHandler.this.paramPath.stream().map(p -> p.getAttribute().getName()).forEach(path::add);
            path.add(leaf.getAttribute().getName());
            Optional<String> value = leaf.getAttribute().getType() == AttributeType.FILE ? leaf.getParameter().map(Parameter::getFileData).map(FileData::getUrl) : DsParamHandler.this.evaluator.apply(leaf);
            return new Leaf(path, value.orElse(""));
        }
    }
}

