/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.utils.AbstractDslUiHandler;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSet;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;

public class DslUiHandler
extends AbstractDslUiHandler {
    private static final String OLD_MACROS_MARKER = "#REF";
    protected final Deque<UiManAttribute> groupsPath = new ArrayDeque<UiManAttribute>();
    protected final DsEvaluator evaluator;
    protected UiManDataSetList result;
    protected UiManAttribute currentAttr;
    protected DataSetParameterProvider dataSetParameterProvider;
    protected MacroContext macroContext;
    protected boolean isEvaluate;

    public DslUiHandler(DsEvaluator evaluator, boolean expandAll) {
        super(expandAll);
        this.evaluator = evaluator;
    }

    public DslUiHandler(DsEvaluator evaluator, MacroContext macroContext, DataSetParameterProvider dataSetParameterProvider, boolean isEvaluate, boolean expandAll) {
        super(expandAll);
        this.evaluator = evaluator;
        this.macroContext = macroContext;
        this.dataSetParameterProvider = dataSetParameterProvider;
        this.isEvaluate = isEvaluate;
    }

    public UiManDataSetList getResult() {
        return this.result;
    }

    @Override
    protected void attributeStarts(Attribute attr) {
        this.currentAttr = new UiManAttribute();
        this.currentAttr.setSource(attr);
        List<UUID> attrPath = this.groupsPath.stream().map(UiManAttribute::getId).collect(Collectors.toList());
        for (int datasetNumber = 0; datasetNumber < this.result.getDataSets().size(); ++datasetNumber) {
            Optional<String> valueOpt;
            UiManDataSet uiDataSet = this.result.getDataSets().get(datasetNumber);
            OverlapIterator overlapIterator = OverlapIterator.create(uiDataSet.getSource(), attr.getId(), attrPath);
            OverlapItem context = (OverlapItem)overlapIterator.next();
            Optional<Parameter> parameter = context.getParameter();
            if (!parameter.isPresent()) continue;
            Parameter param = parameter.get();
            OverlapItem.Reachable reachable = context.asReachable();
            String stingValue = reachable.getValue().orElse("null");
            if (this.isEvaluate && !stingValue.startsWith(OLD_MACROS_MARKER)) {
                AbstractParameter resolvedParameter = this.dataSetParameterProvider.getDataSetParameterResolved(this.result.getId(), parameter.get().getId(), AttributeTypeName.getTypeByName(parameter.get().getAttribute().getType().getName()), this.isEvaluate, this.macroContext, new ParameterPositionContext(Collections.emptyList(), datasetNumber, uiDataSet.getId(), new Random().nextLong(), this.result.getId()));
                valueOpt = Optional.ofNullable(resolvedParameter.getValue());
            } else {
                valueOpt = this.evaluator.apply(reachable);
            }
            Optional<?> valueRefOpt = reachable.getValueRef();
            boolean isOverlap = reachable.isOverlap();
            if (!valueOpt.isPresent() && !valueRefOpt.isPresent() && !isOverlap) continue;
            this.currentAttr.getParameters().add(new UiManParameter(param, reachable.getSourceDs(), reachable.isOverlap(), valueOpt.orElse(null), valueRefOpt.orElse(null)));
        }
    }

    @Override
    protected void goForwardUnderAttribute() {
        this.groupsPath.add(this.currentAttr);
        this.currentAttr = null;
    }

    @Override
    protected void goBackFromAttribute() {
        this.currentAttr = this.groupsPath.removeLast();
    }

    @Override
    protected void attributeEnds() {
        if (this.groupsPath.isEmpty()) {
            this.result.getAttributes().add(this.currentAttr);
        } else {
            this.groupsPath.getLast().getAttributes().add(this.currentAttr);
        }
    }

    @Override
    public void notifyItemStarts(DataSetList dsl) {
        if (this.result == null) {
            this.result = new UiManDataSetList();
            this.result.setSource(dsl);
            for (DataSet dataSet : dsl.getDataSets()) {
                UiManDataSet uiDs = new UiManDataSet();
                uiDs.setSource(dataSet);
                this.result.getDataSets().add(uiDs);
            }
        }
    }

    @Override
    public void notifyProcessingChildren() {
    }

    @Override
    public void notifyChildrenProcessed() {
    }

    @Override
    public void notifyItemEnds() {
    }
}

