/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.ParameterOverlap;
import org.qubership.atp.dataset.model.impl.file.FileData;

public abstract class OverlapItem {
    protected final DataSet sourceDs;

    private OverlapItem(@Nonnull DataSet sourceDs) {
        this.sourceDs = sourceDs;
    }

    @Nonnull
    public abstract Optional<Parameter> getParameter();

    public abstract boolean isReachable();

    @Nonnull
    public abstract Reachable asReachable();

    @Nonnull
    public DataSet getSourceDs() {
        return this.sourceDs;
    }

    @Nullable
    public abstract Collection<UUID> getSearchByAttrPathIds();

    @Nonnull
    public abstract UUID getSearchByTargetAttrId();

    private static abstract class Default
    extends Reachable {
        private Default(@Nonnull DataSet sourceDs, @Nonnull List<Attribute> foundByAttrPath, @Nonnull Attribute foundTargetAttr, @Nonnull DataSet targetDs) {
            super(sourceDs, foundByAttrPath, foundTargetAttr, targetDs);
        }

        @Override
        @Nonnull
        public ParameterOverlap asParameterOverlap() {
            throw new IllegalStateException("It is not an overlap: " + this);
        }

        @Override
        public boolean isParameterOverlap() {
            return false;
        }

        @Override
        public boolean isOverlap() {
            return false;
        }
    }

    public static abstract class Reachable
    extends OverlapItem {
        protected final DataSet targetDs;
        protected final List<Attribute> foundByAttrPath;
        protected final Attribute foundTargetAttr;

        private Reachable(@Nonnull DataSet sourceDs, @Nonnull List<Attribute> foundByAttrPath, @Nonnull Attribute foundTargetAttr, @Nonnull DataSet targetDs) {
            super(sourceDs);
            this.targetDs = targetDs;
            this.foundByAttrPath = foundByAttrPath;
            this.foundTargetAttr = foundTargetAttr;
        }

        @Nonnull
        public DataSet getTargetDs() {
            return this.targetDs;
        }

        @Nonnull
        public abstract ParameterOverlap asParameterOverlap();

        public abstract boolean isParameterOverlap();

        public boolean isLeaf() {
            return !this.isParameterOverlap();
        }

        @Nonnull
        public Attribute getAttribute() {
            return this.foundTargetAttr;
        }

        @Override
        public boolean isReachable() {
            return true;
        }

        @Override
        @Nonnull
        public Reachable asReachable() {
            return this;
        }

        @Nonnull
        public List<Attribute> getFoundByAttrPath() {
            return this.foundByAttrPath;
        }

        public List<UUID> getUuidPath() {
            LinkedList<UUID> result = new LinkedList<UUID>();
            if (this.foundByAttrPath != null) {
                for (Attribute attribute : this.foundByAttrPath) {
                    result.add(attribute.getId());
                }
            }
            return result;
        }

        @Override
        @Nullable
        public Collection<UUID> getSearchByAttrPathIds() {
            return this.foundByAttrPath.stream().map(Identified::getId).collect(Collectors.toList());
        }

        @Override
        @Nonnull
        public UUID getSearchByTargetAttrId() {
            return this.foundTargetAttr.getId();
        }

        public Optional<String> getValue() {
            return this.getParameter().flatMap(param -> {
                switch (this.getAttribute().getType()) {
                    case TEXT: 
                    case ENCRYPTED: 
                    case CHANGE: {
                        return Optional.ofNullable(param.getText());
                    }
                    case LIST: {
                        return Optional.ofNullable(param.getListValue()).map(Named::getName);
                    }
                    case DSL: {
                        return Optional.ofNullable(param.getDataSetReference()).map(Named::getName);
                    }
                    case FILE: {
                        return Optional.ofNullable(param.getFileData()).map(FileData::getFileName);
                    }
                }
                throw new UnsupportedOperationException(String.format("Could not extract text value from parameter %s with type %s", this, this.getAttribute().getType().getName()));
            });
        }

        public Optional<?> getValueRef() {
            return this.getParameter().flatMap(param -> {
                switch (this.getAttribute().getType()) {
                    case LIST: {
                        return Optional.ofNullable(param.getListValue()).map(Identified::getId);
                    }
                    case DSL: {
                        return Optional.ofNullable(param.getDataSetReference()).map(Identified::getId);
                    }
                    case FILE: {
                        return Optional.ofNullable(param.getFileData()).map(FileData::getUrl);
                    }
                }
                return Optional.empty();
            });
        }

        public abstract boolean isOverlap();
    }

    public static class DefaultInitialized
    extends Default {
        private final Parameter parameter;

        public DefaultInitialized(@Nonnull DataSet sourceDs, @Nonnull List<Attribute> foundByAttrPath, @Nonnull DataSet targetDs, @Nonnull Parameter parameter) {
            super(sourceDs, foundByAttrPath, parameter.getAttribute(), targetDs);
            this.parameter = parameter;
        }

        @Override
        @Nonnull
        public Optional<Parameter> getParameter() {
            return Optional.of(this.parameter);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sourceDs", (Object)this.sourceDs).add("foundByAttrPath", (Object)this.foundByAttrPath).add("targetDs", (Object)this.targetDs).add("parameter", (Object)this.parameter).toString();
        }
    }

    protected static class DefaultUninitialized
    extends Default {
        protected DefaultUninitialized(@Nonnull DataSet sourceDs, @Nonnull List<Attribute> foundByAttrPath, @Nonnull Attribute foundTargetAttr, @Nonnull DataSet targetDs) {
            super(sourceDs, foundByAttrPath, foundTargetAttr, targetDs);
        }

        @Override
        @Nonnull
        public Optional<Parameter> getParameter() {
            return Optional.empty();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sourceDs", (Object)this.sourceDs).add("foundByAttrPath", (Object)this.foundByAttrPath).add("foundTargetAttr", (Object)this.foundTargetAttr).add("targetDs", (Object)this.targetDs).toString();
        }
    }

    protected static class Overlap
    extends Reachable {
        private final ParameterOverlap overlap;

        protected Overlap(@Nonnull DataSet sourceDs, @Nonnull List<Attribute> foundByAttrPath, @Nonnull DataSet targetDs, @Nonnull ParameterOverlap overlap) {
            super(sourceDs, foundByAttrPath, overlap.getAttribute(), targetDs);
            this.overlap = overlap;
        }

        @Override
        @Nonnull
        public Optional<Parameter> getParameter() {
            return Optional.of(this.overlap);
        }

        @Override
        @Nonnull
        public ParameterOverlap asParameterOverlap() {
            return this.overlap;
        }

        @Override
        public boolean isParameterOverlap() {
            return true;
        }

        @Override
        public boolean isOverlap() {
            return this.getSourceDs().equals(this.getTargetDs());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sourceDs", (Object)this.sourceDs).add("foundByAttrPath", (Object)this.foundByAttrPath).add("targetDs", (Object)this.targetDs).add("overlap", (Object)this.overlap).toString();
        }
    }

    protected static class Unreachable
    extends OverlapItem {
        private final Collection<UUID> attributePathIds;
        private final UUID targetAttributeId;
        private final DataSet notFoundIn;
        private final UUID notFoundAttr;

        protected Unreachable(@Nonnull DataSet sourceDs, @Nullable Collection<UUID> attributePathIds, @Nonnull UUID targetAttributeId, @Nonnull DataSet notFoundIn, @Nonnull UUID notFoundAttr) {
            super(sourceDs);
            this.attributePathIds = attributePathIds;
            this.targetAttributeId = targetAttributeId;
            this.notFoundIn = notFoundIn;
            this.notFoundAttr = notFoundAttr;
        }

        @Override
        @Nonnull
        public Optional<Parameter> getParameter() {
            return Optional.empty();
        }

        @Override
        public boolean isReachable() {
            return false;
        }

        @Override
        @Nonnull
        public Reachable asReachable() {
            throw new IllegalStateException("Attribute is not reachable: " + this);
        }

        @Override
        @Nullable
        public Collection<UUID> getSearchByAttrPathIds() {
            return this.attributePathIds;
        }

        @Override
        @Nonnull
        public UUID getSearchByTargetAttrId() {
            return this.targetAttributeId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sourceDs", (Object)this.sourceDs).add("attributePathIds", this.attributePathIds).add("targetAttributeId", (Object)this.targetAttributeId).add("notFoundIn", (Object)this.notFoundIn).add("notFoundAttr", (Object)this.notFoundAttr).toString();
        }
    }
}

