/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;

public class OverlapLayers {
    private final Deque<UUID> currentAttrPath;
    private final Deque<DataSet> resolvedLayers = new ArrayDeque<DataSet>();
    private final List<Attribute> resolvedAttrPath;

    private OverlapLayers(@Nonnull DataSet ds) {
        this(ds, new ArrayDeque<UUID>());
    }

    private OverlapLayers(@Nonnull DataSet ds, @Nonnull Deque<UUID> currentAttrPath) {
        this.resolvedLayers.add(ds);
        this.currentAttrPath = currentAttrPath;
        this.resolvedAttrPath = currentAttrPath.isEmpty() ? Collections.emptyList() : new ArrayList(currentAttrPath.size());
    }

    public static OverlapIterator overlapIterator(@Nonnull DataSet ds, @Nonnull UUID targetAttrId, @Nullable Collection<UUID> attrPath) {
        if (attrPath == null || attrPath.isEmpty()) {
            return new OverlapIterator(ds, null, targetAttrId, (Iterator<DataSet>)Iterators.singletonIterator((Object)ds), Collections.emptyList());
        }
        OverlapLayers overlapLayers = new OverlapLayers(ds, new ArrayDeque<UUID>(attrPath));
        return new OverlapIterator(ds, new ArrayDeque<UUID>(attrPath), targetAttrId, overlapLayers.iterator(), overlapLayers.resolvedAttrPath);
    }

    @Nonnull
    private Iterator<DataSet> iterator() {
        if (this.resolvedLayers.size() > this.currentAttrPath.size()) {
            return this.resolvedLayers.iterator();
        }
        return Iterators.concat(this.resolvedLayers.iterator(), (Iterator)((Object)new LazyResolveIterator()));
    }

    private class LazyResolveIterator
    extends AbstractIterator<DataSet> {
        private LazyResolveIterator() {
        }

        protected DataSet computeNext() {
            if (OverlapLayers.this.currentAttrPath.size() < OverlapLayers.this.resolvedLayers.size()) {
                return (DataSet)this.endOfData();
            }
            ArrayDeque attrPath = OverlapLayers.this.currentAttrPath.stream().limit(OverlapLayers.this.resolvedLayers.size()).collect(Collectors.toCollection(ArrayDeque::new));
            UUID targetAttrId = (UUID)attrPath.removeLast();
            Iterator<DataSet> layersToCheck = OverlapLayers.this.resolvedLayers.iterator();
            OverlapIterator ref = new OverlapIterator((DataSet)OverlapLayers.this.resolvedLayers.getFirst(), attrPath, targetAttrId, layersToCheck, OverlapLayers.this.resolvedAttrPath);
            if (!ref.hasNext()) {
                return (DataSet)this.endOfData();
            }
            OverlapItem refSup = (OverlapItem)ref.next();
            if (!refSup.isReachable()) {
                return (DataSet)this.endOfData();
            }
            OverlapItem.Reachable reachable = refSup.asReachable();
            Optional<Parameter> parameterOpt = reachable.getParameter();
            if (!parameterOpt.isPresent() || reachable.getAttribute().getType() != AttributeType.DSL) {
                return (DataSet)this.endOfData();
            }
            DataSet dataSetReference = parameterOpt.get().getDataSetReference();
            if (dataSetReference == null) {
                return (DataSet)this.endOfData();
            }
            OverlapLayers.this.resolvedAttrPath.add(reachable.getAttribute());
            OverlapLayers.this.resolvedLayers.add(dataSetReference);
            return dataSetReference;
        }
    }
}

