/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.dscontext;

import java.io.Serializable;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;

public class ParameterContext
implements Serializable {
    private static final long serialVersionUID = -2995730089590160691L;
    private UUID attributeId;
    private UUID parameterId;
    private long order;
    private String name;
    private AttributeTypeName type;
    private String value;
    private UUID dataSetReferenceId;
    private UUID listValueId;
    private boolean overlap;
    private boolean nullValue;

    public ParameterContext(Attribute parentTextAttribute, Parameter parameter, boolean overlap) {
        this.name = parentTextAttribute.getName();
        this.attributeId = parentTextAttribute.getId();
        this.value = parameter.getParameterValueByType();
        this.dataSetReferenceId = parameter.getDataSetReferenceId();
        this.type = parentTextAttribute.getAttributeType();
        this.parameterId = parameter.getId();
        this.order = parentTextAttribute.getOrdering().intValue();
        this.overlap = overlap;
        if (parameter.getListValue() != null) {
            this.listValueId = parameter.getListValue().getId();
        }
    }

    public ParameterContext(Attribute parentTextAttribute) {
        this.attributeId = parentTextAttribute.getId();
        this.name = parentTextAttribute.getName();
        this.order = parentTextAttribute.getOrdering().intValue();
        this.type = parentTextAttribute.getAttributeType();
        this.nullValue = true;
    }

    public UUID getAttributeId() {
        return this.attributeId;
    }

    public UUID getParameterId() {
        return this.parameterId;
    }

    public long getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public AttributeTypeName getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public UUID getDataSetReferenceId() {
        return this.dataSetReferenceId;
    }

    public UUID getListValueId() {
        return this.listValueId;
    }

    public boolean isOverlap() {
        return this.overlap;
    }

    public boolean isNullValue() {
        return this.nullValue;
    }

    public void setAttributeId(UUID attributeId) {
        this.attributeId = attributeId;
    }

    public void setParameterId(UUID parameterId) {
        this.parameterId = parameterId;
    }

    public void setOrder(long order) {
        this.order = order;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(AttributeTypeName type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setDataSetReferenceId(UUID dataSetReferenceId) {
        this.dataSetReferenceId = dataSetReferenceId;
    }

    public void setListValueId(UUID listValueId) {
        this.listValueId = listValueId;
    }

    public void setOverlap(boolean overlap) {
        this.overlap = overlap;
    }

    public void setNullValue(boolean nullValue) {
        this.nullValue = nullValue;
    }
}

