/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.dsllazyload.referencedcontext;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.dscontext.ParameterContext;
import org.qubership.atp.dataset.service.jpa.model.dsllazyload.referencedcontext.RefParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;

public class RefDataSetListAttribute {
    private UUID id;
    private String name;
    private AttributeTypeName type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean containsAttributes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<RefParameter> parameters = new LinkedList<RefParameter>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private UUID dataSetListReference;

    public RefDataSetListAttribute(Attribute referencedAttribute, Map<UUID, ParameterContext> parameters, List<UUID> path, DataSetParameterProvider parameterProvider, UUID dataSetListId) {
        this.id = referencedAttribute.getId();
        this.name = referencedAttribute.getName();
        this.type = referencedAttribute.getAttributeType();
        if (referencedAttribute.getAttributeType().equals((Object)AttributeTypeName.DSL)) {
            DataSetList typeDataSetList = referencedAttribute.getTypeDataSetList();
            this.containsAttributes = typeDataSetList.getAttributesCount() > 0;
            if (typeDataSetList.getId() != null) {
                this.dataSetListReference = typeDataSetList.getId();
            }
        }
        int column = 0;
        for (Map.Entry<UUID, ParameterContext> parameterContext : parameters.entrySet()) {
            if (parameterContext.getValue().isNullValue()) continue;
            ParameterPositionContext positionContext = new ParameterPositionContext(path, column, parameterContext.getKey(), parameterContext.getValue().getOrder(), dataSetListId);
            if (this.type == AttributeTypeName.FILE) {
                FileData fileInfo = parameterProvider.getFileVariableInfo(parameterContext.getValue().getParameterId());
                if (fileInfo == null) continue;
                this.parameters.add(new RefParameter(parameterContext.getKey(), parameterContext.getValue(), parameterContext.getValue().isOverlap(), positionContext, parameterProvider, fileInfo));
            } else {
                this.parameters.add(new RefParameter(parameterContext.getKey(), parameterContext.getValue(), parameterContext.getValue().isOverlap(), positionContext, parameterProvider));
            }
            ++column;
        }
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public AttributeTypeName getType() {
        return this.type;
    }

    public Boolean getContainsAttributes() {
        return this.containsAttributes;
    }

    public List<RefParameter> getParameters() {
        return this.parameters;
    }

    public UUID getDataSetListReference() {
        return this.dataSetListReference;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(AttributeTypeName type) {
        this.type = type;
    }

    public void setContainsAttributes(Boolean containsAttributes) {
        this.containsAttributes = containsAttributes;
    }

    public void setParameters(List<RefParameter> parameters) {
        this.parameters = parameters;
    }

    public void setDataSetListReference(UUID dataSetListReference) {
        this.dataSetListReference = dataSetListReference;
    }
}

