/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;

public abstract class AbstractTextParameter
extends AbstractParameter {
    @JsonIgnore
    protected List<AbstractTextParameter> childTextParameters = new LinkedList<AbstractTextParameter>();
    @JsonIgnore
    protected String parameters;
    @JsonIgnore
    protected boolean skipExternalChildrenParse = false;

    @Override
    public AttributeTypeName getType() {
        return AttributeTypeName.TEXT;
    }

    public void addTextParameter(AbstractTextParameter textParameter) {
        this.childTextParameters.add(textParameter);
    }

    @JsonIgnore
    public List<String> getArguments() {
        return this.childTextParameters.stream().map(AbstractParameter::getValue).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    public List<AbstractTextParameter> getChildTextParameters() {
        return this.childTextParameters;
    }

    @JsonIgnore
    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public boolean isSkipExternalChildrenParse() {
        return this.skipExternalChildrenParse;
    }
}

