/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.antlr4.TextParameterParser;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractTextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;

public class TextParameter
extends AbstractTextParameter {
    private String value = null;
    @JsonIgnore
    protected Map<ParameterPositionContext, String> cachedValues = null;
    @JsonIgnore
    private ParameterPositionContext positionContext;

    public TextParameter(String value, boolean evaluate, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        TextParameterParser parser = new TextParameterParser(macroContext, parameterPositionContext);
        if (StringUtils.isEmpty((String)value)) {
            this.childTextParameters.add(new TextParameter("", parameterPositionContext));
        } else {
            List<AbstractTextParameter> parseResult = parser.parse(value, evaluate);
            this.childTextParameters.addAll(parseResult);
        }
        this.setOrder(parameterPositionContext.getOrder());
        this.positionContext = parameterPositionContext;
        this.skipExternalChildrenParse = true;
    }

    public TextParameter(String value, ParameterPositionContext parameterPositionContext) {
        this.setOrder(parameterPositionContext.getOrder());
        this.value = value;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValue() {
        if (this.cachedValues != null && this.positionContext != null && this.cachedValues.containsKey(this.positionContext)) {
            return this.cachedValues.get(this.positionContext);
        }
        String result = this.childTextParameters.size() > 0 ? String.join((CharSequence)"", this.getArguments()) : this.value;
        if (this.cachedValues != null && this.positionContext != null) {
            this.cachedValues.put(this.positionContext, result);
        }
        return result;
    }

    @Override
    public boolean isNullValue() {
        List<AbstractTextParameter> childTextParameters = this.getChildTextParameters();
        if (childTextParameters.isEmpty()) {
            return Strings.isNullOrEmpty((String)this.value);
        }
        for (AbstractTextParameter childTextParameter : childTextParameters) {
            if (childTextParameter.isNullValue()) continue;
            return false;
        }
        return true;
    }

    @JsonIgnore
    public void setCachedValues(Map<ParameterPositionContext, String> cachedValues) {
        this.cachedValues = cachedValues;
    }
}

