/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.rest.facade.AttachmentControllerFacade;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/attachment"})
public class AttachmentController {
    private static final Logger log = LoggerFactory.getLogger(AttachmentController.class);
    private final AttachmentControllerFacade attachmentControllerFacade;

    @PreAuthorize(value="@entityAccess.checkAccess(@parameterServiceImpl.get(#parameterUuid).getDataSet().getDataSetList().getVisibilityArea().getId(),'READ')")
    @AuditAction(auditAction="Get file by parameter: {{#parameterUuid}}")
    @GetMapping(value={"/{parameterUuid}"})
    public ResponseEntity<InputStreamResource> getAttachmentByParameterId(@PathVariable(value="parameterUuid") UUID parameterUuid) {
        return this.attachmentControllerFacade.getAttachmentByParameterId(parameterUuid);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@dataSetServiceImpl.get(#datasetId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @AuditAction(auditAction="Get file by attribute: {{#attributeId}} and dataset: {{#datasetId}}")
    @GetMapping(value={"/attributeId/{attributeId}/dataset/{datasetId}"})
    public ResponseEntity<InputStreamResource> getAttachmentByAttributeIdAndDatasetId(@PathVariable(value="attributeId") UUID attributeId, @PathVariable(value="datasetId") UUID datasetId) {
        return this.attachmentControllerFacade.getAttachmentByAttributeIdAndDatasetId(attributeId, datasetId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@parameterServiceImpl.get(#parameterUuid).getDataSet().getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @AuditAction(auditAction="Upload file by parameter: {{#parameterUuid}}")
    @PostMapping(value={"/{parameterUuid}"})
    public FileData uploadByParameterId(@PathVariable(value="parameterUuid") UUID parameterUuid, @RequestParam(value="type") String contentType, @RequestParam(value="fileName") String fileName, InputStream file) throws IOException {
        return this.attachmentControllerFacade.uploadByParameterId(parameterUuid, contentType, fileName, file);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@dataSetServiceImpl.get(#datasetId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @AuditAction(auditAction="Upload file by attribute: {{#attributeId}} and dataset: {{#datasetId}}")
    @PostMapping(value={"/attributeId/{attributeId}/dataset/{datasetId}"})
    public ResponseEntity<FileData> uploadByAttributeIdAndDatasetId(@PathVariable(value="attributeId") UUID attributeId, @PathVariable(value="datasetId") UUID datasetId, @RequestParam(value="type") String contentType, @RequestParam(value="fileName") String fileName, @RequestParam(value="attrPath", required=false) List<UUID> attrPathIds, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, InputStream file) {
        return this.attachmentControllerFacade.uploadByAttributeIdAndDatasetId(attributeId, datasetId, contentType, fileName, attrPathIds, dataSetListId, modifiedWhen, file);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@parameterServiceImpl.get(#parameterId).getDataSet().getDataSetList().getVisibilityArea().getId(),'DELETE')")
    @AuditAction(auditAction="Delete file by parameter: {{#parameterUuid}}")
    @DeleteMapping(value={"/{parameterUuid}"})
    public ResponseEntity<Void> deleteByParameterId(@PathVariable(value="parameterUuid") UUID parameterId) {
        return this.attachmentControllerFacade.deleteByParameterId(parameterId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@dataSetServiceImpl.get(#datasetId).getDataSetList().getVisibilityArea().getId(),'DELETE')")
    @AuditAction(auditAction="Delete file by attribute: {{#attributeId}} and dataset: {{#datasetId}}")
    @DeleteMapping(value={"/attributeId/{attributeId}/dataset/{datasetId}"})
    public ResponseEntity<Void> deleteByAttributeIdAndDatasetId(@PathVariable(value="attributeId") UUID attributeId, @PathVariable(value="datasetId") UUID datasetId) {
        return this.attachmentControllerFacade.deleteByAttributeIdAndDatasetId(attributeId, datasetId);
    }

    public AttachmentController(AttachmentControllerFacade attachmentControllerFacade) {
        this.attachmentControllerFacade = attachmentControllerFacade;
    }
}

